﻿<?php
//////////////////////////////////////////////////////////////
/**
 Rozbudowana klasa SQLiteDatabase, która wyrzuca wyjątki podczas tworzenia zestawu wyyników i posiada dodatkowe funkcje użytkowe
*/
class SQLiteDatabasePlus extends SQLiteDatabase{
    private $tablenames;
//////////////////////////////////////////////////////////////
//publiczne funkcje związawne z zapytaniami
/**
Funkcja przesłonięta
*/
    public function query($strsql, $type = SQLITE_BOTH, &$err_msg = ''){
    //SQLiteResult query( string query [, int result_type [, string &error_msg]] )
        if ( false === $result = parent::query($strsql, $type, $err_msg)){
            //żadnych szczegółów dotyczacych SQL z ostatnim błędem
            throw new SQLiteException (sqlite_error_string($this->lastError()));
        }
        return $result;
    }
//////////////////////////////////////////////////////////////
/**
Funkcja przesłonięta
*/
    public function unbufferedQuery($strsql, $type = SQLITE_BOTH, &$err_msg = ''){
        //SQLiteUnbuffered unbufferedQuery ( string query [, int result_type [, string &error_msg]] )
        if ( false === $result = parent::unbufferedQuery($strsql, $type, $err_msg)){
            throw new SQLiteException (sqlite_error_string($this->lastError()));
        }
        return $result;
    }
//////////////////////////////////////////////////////////////
/**
Funkcja przesłonięta
*/
   public function singleQuery($strsql, $first_column = true, $bin_decode = false){
       //array sqlite_single_query ( resource db, string query [, bool first_row_only [, bool decode_binary]] )
        if ( false === $result = parent::singleQuery($strsql, $first_column, $bin_decode)){
            throw new SQLiteException (sqlite_error_string($this->lastError()));
        }
        return $result;
    }
//////////////////////////////////////////////////////////////
/**
Funkcja przesłonięta
*/
   public function queryExec($strsql, &$err_msg = ''){
       //bool queryExec ( string query [, string &error_msg] )
       if ( !parent::queryExec($strsql, $err_msg)){
            throw new SQLiteException (sqlite_error_string($this->lastError()));
       }
       return true;
   }
//////////////////////////////////////////////////////////////
/**
Funkcja przesłonięta
*/
    public function arrayQuery($strsql, $type = SQLITE_BOTH, $bin_decode = false ){
   //array arrayQuery ( string query [, int result_type [, bool decode_binary]] )
       if ( false === $result = parent::arrayQuery($strsql, $type, $bin_decode)){
            throw new SQLiteException (sqlite_error_string($this->lastError()));
       }
       return $result;
   }
//////////////////////////////////////////////////////////////
/**
Zwraca czyste wysłane dane - sprawdza czy nazwy pól są nazwami zmiennych
*/
    public function cleanData($post, $tablename){
        if (!isset($this->tablenames)){
            $this->setTablenames();
        }
        $this->matchNames($post, $tablename);
        //włączony, usuwa ukośniki
        if(get_magic_quotes_gpc()){
            foreach ($post as $key=>$value){
                $post[$key]=stripslashes($value);
            }
        }
        foreach ($post as $key=>$value){
            $post[$key] = htmlentities(sqlite_escape_string($value));
        }
        return $post;
    }
//////////////////////////////////////////////////////////////
/**
 Upewnia się, że nazwy wysłane z formularza odpwiadają nazwom pól tabeli
*/
    public function matchNames($post, $tablename){
        //spradzanie, czt tablica jest przygotowana
        if (!isset($this->tablenames)){
            $this->setTablenames();
        }
        if (count($post) == 0){
            throw new SQLiteException("Tablica nie została przygotowana.");
        }
        $fields = $this->getFields($tablename);
        foreach ($post as $name=>$value){
            if (!array_key_exists($name, $fields)){
                $message = "W tablicy $tablename nie ma kolumny odpowiadającej zmiennej $name.";
                throw new SQLiteException($message);
            }
        }
    }
//////////////////////////////////////////////////////////////
/**
 Pobiera wszystkie nazwy tablic z bazy
*/
    public function getTableNames(){
        if (!isset($this->tablenames)){
            $this->setTablenames();
        }
        return $this->tablenames;
    }
/////////////////////////////////////////////////////////////
/**
 Odzyskuje nazwy/typy pól dla wskazanej tabeli
*/
    public function getFields($tablename){
        if (!isset($this->tablenames)){
            $this->setTablenames();
        }
        if (!in_array($tablename, $this->tablenames)){
            throw new SQLiteException("W bazie nie ma tablicy $tablename.");
        }
        $fieldnames = array();
        $sql = "PRAGMA table_info('$tablename')";
        $result = $this->unbufferedQuery($sql);
        //brak błędu - ignoruje złą PRAGMA
        //pobiera nazwę i typ danych zdefinowae podczas zakładania
        foreach ($result as $row){
            $fieldnames[$row['name']] = $row['type'];
        }
        return $fieldnames;
    }
//////////////////////////////////////////////////////////////
//metody prywatne
/**
 metoda prywatna - inicjalizuje tablicę z nazwami tabel
*/
    private function setTableNames(){
        $sql = "SELECT name ".
            "FROM sqlite_master ".
            "WHERE type = 'table' ".
            "OR type = 'view'";
        $result = $this->unbufferedQuery($sql);
        foreach  ($result as $row){
            $this->tablenames[] = $row['name'];
        }
    }
}//koniec klasy
?>

