﻿<?php
//wymaga GD 2.0.1 lub wyższej
class ThumbnailImage{
	var $image;
	//nie odnosi się do gif i png
	var $quality = 100;
	var $mimetype;
	var $imageproperties;
	var $initialfilesize;
////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////
	 function __construct($file, $thumbnailsize = 100){
		//sprawdza ścieżkę
		is_file($file) or die ("Plik: $file nie istnieje.");
		$this->initialfilesize = filesize($file);
		$this->imageproperties = getimagesize($file) or die ("Incorrect file type.");
		// nowa funkcja image_type_to_mime_type
		$this->mimetype = image_type_to_mime_type($this->imageproperties[2]);	
		//tworzy obraz
		switch($this->imageproperties[2]){
			case IMAGETYPE_JPEG:
				$this->image = imagecreatefromjpeg($file);	
				break;
			case IMAGETYPE_GIF:	
				$this->image = imagecreatefromgif($file);
				break;
			case IMAGETYPE_PNG:
				$this->image = imagecreatefrompng($file);
				break;
			default:
				die("Nie można utworzyć obrazu.");
		}
		$this->createThumb($thumbnailsize);
	}
////////////////////////////////////////////////////////
//destructor - invoke directly in PHP 4
////////////////////////////////////////////////////////
	 function __destruct(){
		if(isset($this->image)){
			imagedestroy($this->image);			
		}
	}
////////////////////////////////////////////////////////
//destruktor
////////////////////////////////////////////////////////
	 function getImage(){
		header("Content-type: $this->mimetype");
		switch($this->imageproperties[2]){
			case IMAGETYPE_JPEG:
				imagejpeg($this->image,"",$this->quality);
				break;
			case IMAGETYPE_GIF:
				imagegif($this->image);
				break;
			case IMAGETYPE_PNG:
				imagepng($this->image,"",$this->quality);
				break;
			default:
				die("Nie można utworzyć obrazu.");
		}
	}
////////////////////////////////////////////////////////
	 function getMimeType(){
  
		return $this->mimetype;
	}
////////////////////////////////////////////////////////
	 function getQuality(){
		$quality = null;
		if($this->imageproperties[2] == IMAGETYPE_JPEG	|| $this->imageproperties[2] == IMAGETYPE_PNG){
			$quality = $this->quality;
		}
		return $quality;
	}
////////////////////////////////////////////////////////
	 function setQuality($quality){
		if($quality > 100 || $quality  <  1){
			$quality = 75;
    }
		if($this->imageproperties[2] == IMAGETYPE_JPEG || $this->imageproperties[2] == IMAGETYPE_PNG){
			$this->quality = $quality;
		}
	}
////////////////////////////////////////////////////////
	 function getInitialFileSize(){	
		return $this->initialfilesize;
	}
////////////////////////////////////////////////////////
//metody prywatne
////////////////////////////////////////////////////////
	function createThumb($thumbnailsize){
		//elementy tablicy
		$srcW = $this->imageproperties[0];
		$srcH = $this->imageproperties[1];
		//dopasowuje jedynie, jeśli większy niż rozmiar redukcji
		if($srcW >$thumbnailsize || $srcH > $thumbnailsize){
			$reduction = $this->calculateReduction($thumbnailsize);
			//pobiera proporcje
  		$desW = $srcW/$reduction;
  		$desH = $srcH/$reduction;								
			$copy = imagecreatetruecolor($desW, $desH);			
			imagecopyresampled($copy,$this->image,0,0,0,0,$desW, $desH, $srcW, $srcH)
				 or die ("Kopiowanie pliku nie powiodło się.");
			//niszczy oryginał
			imagedestroy($this->image);
			$this->image = $copy;			
		}
	}
////////////////////////////////////////////////////////
	function calculateReduction($thumbnailsize){
		//dopasowuje
		$srcW = $this->imageproperties[0];
		$srcH = $this->imageproperties[1];
  	if($srcW < $srcH){
  		$reduction = round($srcH/$thumbnailsize);
  	}else{  			
  		$reduction = round($srcW/$thumbnailsize);
  	}
		return $reduction;
	}
}//koniec klasy
////////////////////////////////////////////////////////
?>
