﻿<?php
//wymaga GD 2.0.1 lub wyższej
//uwaga o gif
class ThumbnailImage{
	private $image;
	//nie odnosi się do gif i png
	private $quality = 100;
	private $mimetype;
	private $imageproperties;
	private $initialfilesize;
////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////
	public function __construct($file, $thumbnailsize = 100){
		//sprawdza ścieżkę
		is_file($file) or die ("Plik: $file nie istnieje.");
		$this->initialfilesize = filesize($file);
		$this->imageproperties = getimagesize($file) or die ("Niepoprawne rozszerzenie.");
		// nowa funkcja image_type_to_mime_type
		$this->mimetype = image_type_to_mime_type($this->imageproperties[2]);	
		//tworzy obraz
		switch($this->imageproperties[2]){
			case IMAGETYPE_JPEG:
				$this->image = imagecreatefromjpeg($file);	
				break;
			case IMAGETYPE_GIF:	
				$this->image = imagecreatefromgif($file);
				break;
			case IMAGETYPE_PNG:
				$this->image = imagecreatefrompng($file);
				break;
			default:
				die("Nie można utworzyć obrazu.");
		}
		$this->createThumb($thumbnailsize);
	}
////////////////////////////////////////////////////////
//destruktor
////////////////////////////////////////////////////////
	public function __destruct(){
		if(isset($this->image)){
			imagedestroy($this->image);			
		}
	}
////////////////////////////////////////////////////////
//metody publiczne
////////////////////////////////////////////////////////
	public function getImage(){
		header("Content-type: $this->mimetype");
		switch($this->imageproperties[2]){
			case IMAGETYPE_JPEG:
				imagejpeg($this->image,"",$this->quality);
				break;
			case IMAGETYPE_GIF:
				imagegif($this->image);
				break;
			case IMAGETYPE_PNG:
				imagepng($this->image);
				break;
			default:
				die("Nie można utworzyć obrazu.");
		}
	}
////////////////////////////////////////////////////////
	public function getMimeType(){
  
		return $this->mimetype;
	}
////////////////////////////////////////////////////////
	public function getQuality(){
		$quality = null;
		if($this->imageproperties[2] == IMAGETYPE_JPEG){
			$quality = $this->quality;
		}
		return $quality;
	}
////////////////////////////////////////////////////////
	public function setQuality($quality){
		if($quality > 100 || $quality  <  1){
			$quality = 75;
    }
		if($this->imageproperties[2] == IMAGETYPE_JPEG){
			$this->quality = $quality;
		}
	}
////////////////////////////////////////////////////////
	public function getInitialFileSize(){	
		return $this->initialfilesize;
	}
////////////////////////////////////////////////////////
//metody prywatne
////////////////////////////////////////////////////////
	private function createThumb($thumbnailsize){
		//tablica elementów
		$srcW = $this->imageproperties[0];
		$srcH = $this->imageproperties[1];
		//dopasowuje jedynie, jeśli większy niż rozmiar redukcji
		if($srcW >$thumbnailsize || $srcH > $thumbnailsize){
			$reduction = $this->calculateReduction($thumbnailsize);
			//pobiera proporcje
  		$desW = $srcW/$reduction;
  		$desH = $srcH/$reduction;								
			$copy = imagecreatetruecolor($desW, $desH);			
			imagecopyresampled($copy,$this->image,0,0,0,0,$desW, $desH, $srcW, $srcH)
				 or die ("Kopiowanie pliku nie powiodło się.");			
			//niszczy oryginał
			imagedestroy($this->image);
			$this->image = $copy;			
		}
	}
////////////////////////////////////////////////////////
	private function calculateReduction($thumbnailsize){
		//dopasowuje
		$srcW = $this->imageproperties[0];
		$srcH = $this->imageproperties[1];
  	if($srcW < $srcH){
  		$reduction = round($srcH/$thumbnailsize);
  	}else{  			
  		$reduction = round($srcW/$thumbnailsize);
  	}
		return $reduction;
	}
}//koniec klasy
////////////////////////////////////////////////////////
?>
