﻿<?php
class DirectoryItems{
	//dane składowe
	private $filearray = array();
	private $replacechar;
	private $directory;
//////////////////////////////////////////////////////////////////
//konstruktor
/////////////////////////////////////////////////////////////////
  public function __construct($directory, $replacechar = "_"){
		$this->directory = $directory;
		$this->replacechar = $replacechar;
		$d = "";
  	if(is_dir($directory)){
  		$d = opendir($directory) or die("Nie można otworzyć katalogu.");
  		while(false !== ($f = readdir($d))){
    		if(is_file("$directory/$f")){
					$title = $this->createTitle($f);
					$this->filearray[$f] = $title;
    		}
  		}
			closedir($d);
		}else{
			//błąd
			die("Zrezygnowano z dostępu do katalogu.");
		}
	}
//////////////////////////////////////////////////////////////////
//destruktor
//////////////////////////////////////////////////////////////////
	public function __destruct(){
		unset($this->filearray);
	}
//////////////////////////////////////////////////////////////////
//funkcje publiczne
//////////////////////////////////////////////////////////////////
	public function getDirectoryName(){
		return $this->directory;
	}
//////////////////////////////////////////////////////////////////
	public function indexOrder(){
		sort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	public function naturalCaseInsensitiveOrder(){
		natcasesort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
//zwraca wartość false, jeśli nie wszystkie pliki mają podane rozszerzenia
//////////////////////////////////////////////////////////////////
	public function checkAllImages(){
		$bln = true;
		$extension = "";
		$types =  array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value){
			$extension = substr($key,(strpos($key, ".")+1));
			$extension =  strtolower($extension);
			if(!in_array($extension, $types)){
				$bln = false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
//zwraca wartość false, jeśli nie wszystkie rozszerzenia są określone
//////////////////////////////////////////////////////////////////
	public function checkAllSpecificType($extension){
		$extension = strtolower($extension);
		$bln = true;
		$ext = "";
		foreach ($this->filearray as $key => $value){
			$ext = substr($key,(strpos($key, ".")+1));
			$ext =  strtolower($ext);
			if($extension != $ext){
				$bln = false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
	public function getCount(){
		return count($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	public function getFileArray(){
		return $this->filearray;
	}
//////////////////////////////////////////////////////////////////
//eliminuje te elementy tablicy, które nie należą do grupy o podanych rozszerzeniach - faza 2
/////////////////////////////////////////////////////////////////
	public function filter($extension){
		$extension = strtolower($extension);
		foreach ($this->filearray as $key => $value)
		{
			$ext = substr($key,(strpos($key, ".")+1));
			$ext =  strtolower($ext);
			if($ext != $extension){
				unset($this->filearray[$key]);
			}
		}
	}
//////////////////////////////////////////////////////////////////
//eliminuje wszystkie elementy tablicy, które nie są obrazami - faza 2
/////////////////////////////////////////////////////////////////
	public function imagesOnly(){
		$extension = "";
		$types =  array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value){
			$extension = substr($key,(strpos($key, ".")+1));
			$extension =  strtolower($extension);
			if(!in_array($extension, $types)){
				unset($this->filearray[$key]);
			}
		}	
	}
//////////////////////////////////////////////////////////////////
//odtwarza tablice po filtrowaniu - faza 2
/////////////////////////////////////////////////////////////////
	public function removeFilter(){
		unset($this->filearray);
		$d = "";
		$d = opendir($this->directory) or die("Nie można otworzyć katalogu.");
		while(false !== ($f = readdir($d))){
  		if(is_file("$this->directory/$f")){
				$title = $this->createTitle($f);
				$this->filearray[$f] = $title;
  		}
		}
		closedir($d);
	}	
//////////////////////////////////////////////////////////////////
//funkcje prywatne
/////////////////////////////////////////////////////////////////
	private function createTitle($title){
		//oddziela rozszerzenie
		$title = substr($title, 0, strrpos($title, "."));
		//zamienia znak separator w nazwie pliku na spację
		$title = str_replace($this->replacechar, " ", $title);
		return $title;
	}
}//koniec klasy	
?>

