<?php

namespace popp\r03;

require_once("vendor/autoload.php");

use popp\r03\zestaw09\ShopProduct;
use popp\r03\zestaw09\AddressManager;
use popp\r03\zestaw09\Runner;

class Batch09Test extends \PHPUnit_Framework_TestCase
{
    public function testShopProduct()
    {
        $product = new ShopProduct(
            "tytuł",
            "imię",
            "nazwisko",
            3.22
        );
        self::assertEquals($product->getProducer(), "imię nazwisko");

        try {
            $product = new ShopProduct("tytuł", "imię", "nazwisko", []);
            self::fail("Oczekiwany wyjątek");
        } catch (\TypeError $e) {
        }

        try {
            Runner::run1();
            self::fail("Oczekiwany wyjątek");
        } catch (\TypeError $e) {

        }

        $product = new ShopProduct(
            "tytuł",
            "imię",
            "nazwisko",
            "3.22"
        );

        self::assertEquals($product->getPrice(), 3.22);
        self::assertEquals(gettype($product->getPrice()), "double");

        ob_start();
        Runner::run2();
        $output = ob_get_contents();
        ob_end_clean();
        self::assertEquals($output, "4.22");
    }

    public function testAddressManager()
    {
        $aman = new AddressManager();
 
        ob_start();
        $aman->outputAddresses(false);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("209.131.36.159\n216.58.213.174\n", $output1);

        ob_start();
        $aman->outputAddresses(true);
        $output2 = ob_get_contents();
        ob_end_clean();
        self::assertRegexp("|209.131.36.159 \\(.*?\\)\n216.58.213.174 \\(.*?\\)\n|", $output2);

        ob_start();
        Runner::run3();
        $output2 = ob_get_contents();
        ob_end_clean();
        // przekazuje "false" - co powinno dać "true" w trybie non-strict
        self::assertRegexp("|209.131.36.159 \\(.*?\\)\n216.58.213.174 \\(.*?\\)\n|", $output2);


/*
        ob_start();
        $aman->outputAddresses("no");
        //$aman->outputAddresses(null);
        //$aman->outputAddresses(-1);
        //$aman->outputAddresses($aman);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("209.131.36.159\n216.58.213.174\n", $output1);

        ob_start();
        $aman->outputAddresses("false");
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("209.131.36.159\n216.58.213.174\n", $output1);

        ob_start();
        $aman->outputAddresses("nottrue");
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertRegexp("|209.131.36.159 \\(.*?\\)\n216.58.213.174 \\(.*?\\)\n|", $output1);

        ob_start();
        $aman->outputAddresses("xxxxx");
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertRegexp("|209.131.36.159 \\(.*?\\)\n216.58.213.174 \\(.*?\\)\n|", $output1);

        ob_start();
        $aman->outputAddresses("off");
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("209.131.36.159\n216.58.213.174\n", $output1);


        ob_start();
        Runner::run2();
        $output3 = ob_get_contents();
        ob_end_clean();
        // "pomyłkowa" prawda (bo "false" == true)
        self::assertEquals("209.131.36.159\n216.58.213.174\n", $output3);
*/
    }
}
