<?php
declare(strict_types = 1);

namespace popp\r09\zestaw10;

/* listing 09.29 */
class BloggsCommsManager extends CommsManager
{
    public function getHeaderText(): string
    {
        return "Nagłówek BloggsCal\n";
    }

    public function make(int $flag_int): Encoder
    {
        switch ($flag_int) {
            case self::APPT:
                return new BloggsApptEncoder();
            case self::CONTACT:
                return new BloggsContactEncoder();
            case self::TTD:
                return new BloggsTtdEncoder();
        }
    }

    public function getFooterText(): string
    {
        return "Stopka BloggsCal\n";
    }
}
