<?php
declare(strict_types=1);

namespace popp\r06\zestaw03;

/* listing 06.05 */
class XmlParamHandler extends ParamHandler
{

    public function write(): bool
    {
        // zapisz XML
        // za pomocą $this->params
/* /listing 06.05 */
        $fh = $this->openSource('w');
        fputs($fh, "<params>\n");
        foreach ($this->params as $key => $val) {
            fputs($fh, "\t<param>\n");
            fputs($fh, "\t\t<key>$key</key>\n");
            fputs($fh, "\t\t<val>$val</val>\n");
            fputs($fh, "\t</param>\n");
        }
        fputs($fh, "</params>\n");
        fclose($fh);
        return true;
/* listing 06.05 */
    }

    public function read(): bool
    {
        // wczytaj XML
        // i wypełnij danymi $this->params
/* /listing 06.05 */
        $el = @simplexml_load_file($this->source);
        if (empty($el)) {
            throw new Exception("nie można przetworzyć $this->source");
        }
        foreach ($el->param as $param) {
            $this->params["$param->key"] = "$param->val";
        }
        return true;
/* listing 06.05 */
    }
}
