<?php
declare(strict_types = 1);

namespace popp\dodB\zestaw01\marklogic;

use popp\dodB\zestaw01\parse\Handler;
use popp\dodB\zestaw01\parse\Parser;
use popp\dodB\zestaw01\parse\Scanner;

use popp\dodB\zestaw01\interpreter\LiteralExpression;

/* listing 24.18 */
class StringLiteralHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner)
    {
        $value = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new LiteralExpression($value));
    }
}
