<?php
declare(strict_types = 1);

namespace popp\r13\zestaw07;

use popp\r13\zestaw05\VenueCollection;
use popp\r13\zestaw05\VenueObjectFactory;
use popp\r13\zestaw05\DomainObjectFactory;
use popp\r13\zestaw05\Collection;

class VenuePersistenceFactory extends PersistenceFactory
{
    public function getMapper(): Mapper
    {
        return new VenueMapper();
    }

    public function getDomainObjectFactory(): DomainObjectFactory
    {
        return new VenueObjectFactory();
    }

    public function getCollection(array $array): Collection
    {
        return new VenueCollection($array, $this->getDomainObjectFactory());
    }

    public function getSelectionFactory(): SelectionFactory
    {
        return new VenueSelectionFactory();
    }

    public function getUpdateFactory(): UpdateFactory
    {
        return new VenueUpdateFactory();
    }

    public function getIdentityObject(): IdentityObject
    {
        return new VenueIdentityObject();
    }
}
