<?php
declare(strict_types = 1);

namespace popp\r11\zestaw08;

/* listing 11.42 */
class TextDumpArmyVisitor extends ArmyVisitor
{
    private $text = "";

    public function visit(Unit $node)
    {
        $txt = "";
        $pad = 4 * $node->getDepth();
        $txt .= sprintf("%{$pad}s", "");
        $txt .= get_class($node) . ": ";
        $txt .= "siła rażenia: " . $node->bombardStrength() . "\n";
        $this->text .= $txt;
    }

    public function getText()
    {
        return $this->text;
    }
}
