<?php
declare(strict_types=1);
namespace popp\r03\zestaw15;

use popp\r03\zestaw15\ShopProduct;

/* listing 03.49 */
class CdProduct extends ShopProduct
{
    private $playLength;

    public function __construct(
        string $title,
        string $firstName,
        string $mainName,
        float  $price,
        int    $playLength
    ) {
        parent::__construct(
            $title,
            $firstName,
            $mainName,
            $price
        );
        $this->playLength = $playLength;
    }

    public function getPlayLength()
    {
        return $this->playLength;
    }

    public function getSummaryLine()
    {
        $base  = "{$this->title} ( {$this->producerMainName}, ";
        $base .= "{$this->producerFirstName} )";
        $base .= ": czas nagrania - {$this->playLength}";
        return $base;
    }
}
/* /listing 03.49 */
