<?php
declare(strict_types=1);
namespace popp\r03;

require_once("vendor/autoload.php");

use popp\r03\zestaw14\ShopProduct;
use popp\r03\zestaw14\BookProduct;
use popp\r03\zestaw14\CdProduct;
use popp\r03\zestaw14\ShopProductWriter;

class Batch14Test extends \PHPUnit_Framework_TestCase
{
    public function testShopProcuct()
    {

        $test4 = new BookProduct("tytuł książki", "imię", "nazwisko", 99, 200);
        self::assertEquals("tytuł książki ( imię, nazwisko ): liczba stron - 200", $test4->getSummaryLine());

        $book = new BookProduct("tytuł książki", "imię", "nazwisko", 99, 200);
        $book->setDiscount(10);
        self::assertEquals($book->getPrice(), 99);

        $cd = new CdProduct("tytuł CD", "imię", "nazwisko", 99, 200);
        $cd->setDiscount(10);
        self::assertEquals($cd->getPrice(), 89);

        $writer = new ShopProductWriter();
        $writer->addProduct($book);
        $writer->addProduct($cd);

        ob_start();
        $writer->write();
        $out4 = ob_get_contents();
        ob_end_clean();
        self::assertEquals($out4, "tytuł książki: imię nazwisko (99)\ntytuł CD: imię nazwisko (89)\n");
    }
}
