<?php
declare(strict_types = 1);

namespace popp\r12\zestaw05;

/* listing 12.13 */
class CommandResolver
{
    private static $refcmd = null;
    private static $defaultcmd = DefaultCommand::class;

    public function __construct()
    {
        // to może być konfigurowalne
        self::$refcmd = new \ReflectionClass(Command::class);
    }

    public function getCommand(Request $request): Command
    {
        $reg = Registry::instance();
        $commands = $reg->getCommands();
        $path = $request->getPath();

        $class = $commands->get($path);

        if (is_null($class)) {
            $request->addFeedback("nie dopasowano ścieżki '$path'");
            return new self::$defaultcmd();
        }

        if (! class_exists($class)) {
            $request->addFeedback("nie odnaleziono klasy '$class'");
            return new self::$defaultcmd();
        }

        $refclass = new \ReflectionClass($class);

        if (! $refclass->isSubClassOf(self::$refcmd)) {
            $request->addFeedback("polecenie '$cmd' nie wchodzi w skład hierarchii Command");
            return new self::$defaultcmd();
        }

        return $refclass->newInstance();
    }
}
/* /listing 12.13 */
