<?php
declare(strict_types=1);
namespace popp\r08\zestaw01;

/* listing 08.01 */
abstract class Lesson
{
    protected $duration;
    const     FIXED = 1;
    const     TIMED = 2;
    private   $costtype;

    public function __construct(int $duration, int $costtype = 1)
    {
        $this->duration = $duration;
        $this->costtype = $costtype;
    }

    public function cost(): int
    {
        switch ($this->costtype) {
            case self::TIMED:
                return (5 * $this->duration);
                break;
            case self::FIXED:
                return 30;
                break;
            default:
                $this->costtype = self::FIXED;
                return 30;
        }
    }

    public function chargeType(): string
    {
        switch ($this->costtype) {
            case self::TIMED:
                return "stawka godzinowa";
                break;
            case self::FIXED:
                return "stawka stała";
                break;
            default:
                $this->costtype = self::FIXED;
                return "stawka stała";
        }
    }

    // pozostałe metody...
}
/* /listing 08.01 */
