<?php
declare(strict_types=1);
namespace popp\r03\zestaw13;

use popp\r03\zestaw13\ShopProduct;

/* listing 03.40 */
class BookProduct extends ShopProduct
{
    public $numPages;

    public function __construct(
        string $title,
        string $firstName,
        string $mainName,
        float  $price,
        int    $numPages
    ) {
        parent::__construct(
            $title,
            $firstName,
            $mainName,
            $price
        );
        $this->numPages = $numPages;
    }

    public function getNumberOfPages()
    {
        return $this->numPages;
    }

    public function getSummaryLine()
    {
        $base  = "{$this->title} ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )";
        $base .= ": liczba stron - {$this->numPages}";
        return $base;
    }
}
/* /listing 03.40 */
