<?php
declare(strict_types = 1);

namespace popp\dodB\zestaw01;

use popp\dodB\zestaw01\parse\Context;
use popp\dodB\zestaw01\parse\Scanner;
use popp\dodB\zestaw01\parse\StringReader;
use popp\dodB\zestaw01\marklogic\MarkParse;

class Runner
{
    public static function run()
    {
        // miejsce na kod inicjujący

        $questions = [
            "how many beans make five?" => '$input equals "five" or $input equals "5"',
            "give a childs name?" => '$input equals "jake" or $input equals "holly"',
            "life begins at" => '$input equals "forty" or $input equals "40"'
        ];

        $answers = ["five", "jake", "40"];

        foreach ($questions as $prompt => $mark) {
            print "$prompt\n";
            $marker = new MarkLogicMarker($mark);
            $result = false;

            do {
                $line = array_shift($answers);

                //$fh = fopen( 'php://stdin', 'r' );
                //$line = fgets( $fh );
                //$line = trim( $line );

                $question = new TextQuestion($prompt, $marker);

                if ($result = $question->mark($line)) {
                    print "dobra robota!\n";
                } else {
                    print "źle, spróbuj jeszcze raz\n";
                }
            } while (! $result);
        }
    }

    public static function run2()
    {
/* listing 24.06 */
        $context = new Context();
        $user_in = "\$input equals '4' or \$input equals 'cztery'";
        $reader = new StringReader($user_in);
        $scanner = new Scanner($reader, $context);

        while ($scanner->nextToken() != Scanner::EOF) {
            print $scanner->token();
            print "   {$scanner->charNo()}";
            print "   {$scanner->getTypeString()}\n";
        }
/* /listing 24.06 */
    }

    public static function run3()
    {
        //$input      = '4';
        //$statement = "( \$input equals '4' or  \$input equals 'cztery' )";
        $input      = 'five';
        $statement = "( \$input equals 'five' or \$input equals 'armpit')";

        $engine = new MarkParse($statement);
        $result = $engine->evaluate($input);
        print "wejście: $input test: $statement\n";

        if ($result) {
            print "prawda!\n";
        } else {
            print "fałsz!\n";
        }
    }
}
