<?php
require_once "fullshop.php";
$prod_class = new ReflectionClass( 'CdProduct' );
$methods = $prod_class->getMethods();

foreach ( $methods as $method ) {
  print methodData( $method );
  print "\n----\n";
}

function methodData( ReflectionMethod $method ) {
  $details = "";
  $name = $method->getName();
  if ( $method->isUserDefined() ) {
    $details .= "$name jest metodą użytkownika\n";
  }
  if ( $method->isInternal() ) {
    $details .= "$name jest metodą wbudowaną\n";
  }
  if ( $method->isAbstract() ) {
    $details .= "$name jest metodą abstrakcyjną\n";
  }
  if ( $method->isPublic() ) {
    $details .= "$name jest metodą publiczną\n";
  }
  if ( $method->isProtected() ) {
    $details .= "$name jest metodą chronioną\n";
  }
  if ( $method->isPrivate() ) {
    $details .= "$name jest metodą prywatną\n";
  }
  if ( $method->isStatic() ) {
    $details .= "$name jest metodą statyczną\n";
  }
  if ( $method->isFinal() ) {
    $details .= "$name jest metodą finalną\n";
  }
  if ( $method->isConstructor() ) {
    $details .= "$name jest konstruktorem\n";
  }
  if ( $method->returnsReference() ) {
    $details .= "$name zwraca referencję (a nie wartość)\n";
  }
  return $details;
}

?>
