<?php
namespace woo\mapper;

$EG_DISABLE_INCLUDES=true;
//require_once( "woo/mapper/Mapper.php" );
require_once( "listing13.01.php" );
require_once( "woo/base/Exceptions.php" );
require_once( "woo/domain/Venue.php" );
//require_once( "woo/mapper/Collections.php" );
//require_once( "woo/domain.php" );

class VenueMapper extends Mapper {

    function __construct() {
        parent::__construct();
        $this->selectStmt = self::$PDO->prepare( 
                            "SELECT * FROM venue WHERE id=?");
        $this->updateStmt = self::$PDO->prepare( 
                            "update venue set name=?, id=? where id=?");
        $this->insertStmt = self::$PDO->prepare( 
                            "insert into venue ( name ) 
                             values( ? )");
    } 
    
    function getCollection( array $raw ) {
        return new SpaceCollection( $raw, $this );
    }

    protected function doCreateObject( array $array ) {
        $obj = new \woo\domain\Venue( $array['id'] );
        $obj->setname( $array['name'] );
        // $space_mapper = new spacemapper();
        // $space_collection = $space_mapper->findbyvenue( $array['id'] );
        // $obj->setspaces( $space_collection );
        return $obj;
    }

    protected function doInsert( \woo\domain\DomainObject $object ) {
        print "wstawianie\n";
        debug_print_backtrace();
        $values = array( $object->getName() ); 
        $this->insertStmt->execute( $values );
        $id = self::$PDO->lastInsertId();
        $object->setId( $id );
    }
    
    function update( \woo\domain\DomainObject $object ) {
        print "aktualizowanie\n";
        $values = array( $object->getName(), $object->getId(), $object->getId() ); 
        $this->updateStmt->execute( $values );
    }

    function selectStmt() {
        return $this->selectStmt;
    }
}

$mapper = new VenueMapper();
$venue = $mapper->find(2);
print_r( $venue );

/*
$venue = new \woo\domain\Venue();
$venue->setName( "The Likey Lounge-yy" );
// dodanie obiektu do bazy danych
$mapper->insert( $venue );
// ponowne wyszukanie obiektu - na dowód, że działa
$venue = $mapper->find( $venue->getId() );
print_r( $venue );
// modyfikacja naszego obiektu
$venue->setName( "The Bibble Beer Likey Lounge-yy" );
// call update to enter the amended data
$mapper->update( $venue );

// znów z bazy danych, na dowód że działa
$venue = $mapper->find( $venue->getId() );
print_r( $venue );
*/
?>
