<?php
require_once "fullshop.php";

$prod_class = new ReflectionClass( 'CdProduct' );
$method = $prod_class->getMethod( "__construct" );
$params = $method->getParameters();

foreach ( $params as $param ) {
    print argData( $param )."\n";
}

function argData( ReflectionParameter $arg ) {
  $details = "";
  $declaringclass = $arg->getDeclaringClass();
  $name  = $arg->getName();
  $class = $arg->getClass();
  $position = $arg->getPosition();
  $details .= "\$$name na pozycji $position\n";
  if ( ! empty( $class )  ) {
    $classname = $class->getName();
    $details .= "\$$name musi być obiektem typu $classname\n";
  }
  
  if ( $arg->isPassedByReference() ) {
    $details .= "\$$name przekazywany przez referencję\n";
  }

  if ( $arg->isDefaultValueAvailable()  ) {
    $def = $arg->getDefaultValue();
    $details .= "\$$name ma wartość domyślną: $def\n";
  }

  if ( $arg->allowsNull()  ) { 
    $details .= "\$$name dopuszcza wartości puste (null)\n";
  }

  return $details;
}
?>
