<?php
session_start();
try {
    // pobiera adres e-mail z żądania
    $email = filter_input(INPUT_POST, 'email');

    // pobiera hasło z żądania
    $password = filter_input(INPUT_POST, 'password');

    // szuka konta o określonym adresie e-mail (pseudokod)
    $user = User::findByEmail($email);

    // porównuje hasło z zapisanym skrótem hasła
    if (password_verify($password, $user->password_hash) === false) {
        throw new Exception('Niepoprawne hasło');
    }

    // w razie potrzeby ponownie miesza hasło (patrz niżej)
    $currentHashAlgorithm = PASSWORD_DEFAULT;
    $currentHashOptions = array('cost' => 15);
    $passwordNeedsRehash = password_needs_rehash(
        $user->password_hash,
        $currentHashAlgorithm,
        $currentHashOptions
    );
    if ($passwordNeedsRehash === true) {
        // zapisuje nowy skrót hasła (pseudokod)
        $user->password_hash = password_hash(
            $password,
            $currentHashAlgorithm,
            $currentHashOptions
        );
        $user->save();
    }

    // zapisuje status logowania w sesji
    $_SESSION['user_logged_in'] = 'yes';
    $_SESSION['user_email'] = $email;

    // przekierowuje na stronę profilu
    header('HTTP/1.1 302 Redirect');
    header('Location: /user-profile.php');
} catch (Exception $e) {
    header('HTTP/1.1 401 Unauthorized');
    echo $e->getMessage();
}
