# Przykład użycia OpenAPI

## Instalacja

Wydaj polecenie `composer install`.

## Utwórz dokumentację interfejsu API.

1. Polecenie `vendor/bin/openapi src/Annotations -o openapi-annotations.yaml` tworzy dokumentację na podstawie przykładu z wykorzystaniem adnotacji.
2. Polecenie `vendor/bin/openapi src/Attributes -o openapi-attributes.yaml` tworzy dokumentację na podstawie przykładu z wykorzystaniem atrybutów.

## Porównaj oba pliki YAML.

Aby sprawdzić różnice pomiędzy oboma plikami YAML, możesz wydać polecenie `git diff --no-index`, porównujące pliki nieśledzone przez git:

`git diff --no-index openapi-annotations.yaml openapi-attributes.yaml`

Jeśli wszystko poszło dobrze, nie powinny zostać zgłoszone żadne różnice.

## Swagger UI

W celu szybkiego zapoznania się z przykładem ściągnij narzędzie Swagger-UI z repozytorium Docker Hub:

`docker pull swaggerapi/swagger-ui`

Ponieważ Swagger-UI obsługuje tylko pliki JSON, a nie YAML, utwórz najpierw dokumentację w tym pierwszym formacie:

`vendor/bin/openapi src/Attributes -o openapi-attributes.json`

Następnie uruchom lokalnie kontener:

```
docker run -p 80:8080 -e SWAGGER_JSON=/foo/openapi-attributes.json -v `pwd`:/foo swaggerapi/swagger-ui
```

Teraz możesz przejść w w przeglądarce na adres http://localhost.