<?php

declare(strict_types=1);

namespace DesignPatterns\FactoryMethod;

abstract class AbstractWriter
{
    public function write(array $data): void
    {
        $encoder = $this->createEncoder();

        // Zastosuj filtrowanie, przeprowadzane zawsze,
        // bez względu na to, jaki jest format wyjściowy.
        array_walk(
            $data,
            function (&$value) {
                $value = str_replace('data', '', $value);
            }
        );

        // W celach demonstracyjnych wypisujemy tu wynik przy użyciu funkcji
        // echo zamiast zapisywać go do pliku.
        echo $encoder->encode($data);
    }

    abstract protected function createEncoder(): Encoder;
}