<?php
/* optymalizacja działania serwera */
set_time_limit(600); // program będzie działał co najmniej 10 minut 
ini_set("default_socket_timeout", 300); // oczekuj najwyżej 5 minut na połączenie
ob_implicit_flush(); // wyświetl wszystkie informacje trafiające do bufora w konsoli

/* parametry połączenia */
$host = 'localhost';
$port = 12345;

$limit = 2; // limit przyjętych połączeń
$cnt = 1; // licznik połączeń

print "<> Uruchamiam serwer...".PHP_EOL;

// utwórz serwer
if (($connect = stream_socket_server('tcp://'.$host.':'.$port)) === false)
{
    die('Nie mogę uruchomić serwera.');
}

print "Gotowe!".PHP_EOL;
print "Limit połączeń: $limit".PHP_EOL;

// zaakceptuj połączenie przychodzące
while ($socket = stream_socket_accept($connect))
{
    print "[$cnt] Zaakceptowane połączenie z klientem.".PHP_EOL;

    $read = stream_socket_recvfrom($socket, 1500, 0, $sender);
    if (empty($read) === false) 
    {
        print "<= Odebrałem wiadomość...".PHP_EOL;
        $response = '';

        switch ($read) 
        {
            case 'czas':
                $response = 'Czas lokalny: ' . date('Y-m-d H:i:s');
                print "<?> Przygotowuję informację o aktualnym czasie...".PHP_EOL;
                break;
            case 'wersja-php':
                $response = 'Wersja PHP: ' . phpversion();
                print "<?> Przygotowuję informację o wersji PHP...".PHP_EOL;
                break;
            default:
                $response = 'Echo: '.$read;
        }

        stream_socket_sendto($socket, $response, 0, (string)$sender);
        print "=> Wysłałem wiadomość...".PHP_EOL;
    }

    fclose($socket);
    sleep(1); // poczekaj chwilkę na kolejne połączenie

    $cnt++;
    if ($cnt > $limit) // sprawdź limit połączeń
    {
        print "[*] Przekroczono limit połączeń.".PHP_EOL;
        break; 
    }
}

print "<> Wyłączam serwer...".PHP_EOL;

// zamknij połączenie (serwera i klienta)
stream_socket_shutdown($connect, \STREAM_SHUT_RDWR);

print "Gotowe!".PHP_EOL;