<?php

declare(strict_types=1);

namespace popp\r24\zestaw01\marklogic;

use popp\r24\zestaw01\parse\Handler;
use popp\r24\zestaw01\parse\Parser;
use popp\r24\zestaw01\parse\Scanner;
use popp\r24\zestaw01\interpreter\VariableExpression;

/* listing 24.20 */
class VariableHandler implements Handler
{
    public function handleMatch(Parser $parser, Scanner $scanner): void
    {
        $varname = $scanner->getContext()->popResult();
        $scanner->getContext()->pushResult(new VariableExpression($varname));
    }
}
