<?php

declare(strict_types=1);

namespace popp\r13\zestaw05;

use popp\r13\zestaw04\ObjectWatcher;
use popp\r13\zestaw04\DomainObject;

/* listing 13.33 */
abstract class DomainObjectFactory
{
    abstract public function createObject(array $row): DomainObject;

/* /listing 13.33 */
    protected function getFromMap($class, $id): ?DomainObject
    {
        return ObjectWatcher::exists($class, $id);
    }

    protected function addToMap(DomainObject $obj): DomainObject
    {
        return ObjectWatcher::add($obj);
    }
/* listing 13.33 */
}
/* /listing 13.33 */
