<?php

declare(strict_types=1);

namespace popp\r11\zestaw09;

use popp\r11\zestaw09\CommandContext;

/* listing 11.52 */
class Controller
{
    private CommandContext $context;

    public function __construct()
    {
        $this->context = new CommandContext();
    }

    public function getContext(): CommandContext
    {
        return $this->context;
    }

    public function process(): void
    {
        $action = $this->context->get('action');
        $action = (is_null($action)) ? "default" : $action;
        $cmd = CommandFactory::getCommand($action);

        if (! $cmd->execute($this->context)) {
            // obsłuż błąd
        } else {
            // sukces
            // wyświetlenie widoku
        }
    }
}
