<?php

declare(strict_types=1);

namespace popp\r04\zestaw10;

use popp\r04\zestaw09\Runner as Runner09;

class Runner
{
    public static function run()
    {
        $path = Runner09::writeConf();
/* listing 04.65 */
        try {
            $conf = new Conf("/tmp/conf01.xml");
            //$conf = new Conf( "/root/unwriteable.xml" );
            //$conf = new Conf( "nonexistent/not_there.xml" );
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
/* listing 04.66 */
        } catch (\Exception $e) {
            // obsługa błędu
/* /listing 04.65 */
            // or
            throw new \Exception("Conf error: " . $e->getMessage());
/* listing 04.65 */
        }
/* /listing 04.65 */
/* /listing 04.66 */
    }

    public static function run2()
    {
/* listing 04.67 */
        try {
            $conf = new Conf("nonexistent/not_there.xml");
        } catch (\Exception $e) {
            // obsłuż błąd...
            // albo wyrzuć go ponownie
            throw $e;
        }
/* /listing 04.67 */
    }

    public static function run3()
    {
/* listing 04.68 */
        try {
            $conf = new Conf("nonexistent/not_there.xml");
        } catch (\Exception) {
            // obsługa błędu bez obiektu Exception
/* /listing 04.68 */
            return 100;
/* listing 04.68 */
        }
/* /listing 04.68 */
        return 5;
    }
}
