<?php

declare(strict_types=1);

namespace popp\r04\zestaw08;

class ProcessSale
{
    private array $callbacks;

    public function registerCallback($callback): void
    {
        if (! is_callable($callback)) {
            throw new \Exception("wyjątek wywołania zwrotnego");
        }
        $this->callbacks[] = $callback;
    }

    public function sale($product): void
    {
        print "{$product->name}: przetwarzanie sprzedaży\n";
        foreach ($this->callbacks as $callback) {
            call_user_func($callback, $product);
        }
    }
}
