<?php
interface Observer { 
   public function update();
}

abstract class Widget implements Observer {

   protected $internalData = array();

   abstract public function draw();

   public function update(Observable $subject) { 
      $this->internalData = $subject->getData();
   }
}

class BasicWidget extends Widget {

   function __construct() {
   }

   public function draw() {
      $html = "<table border=l width=130>";
      $html .= "<tr><td colspan=3 bgcolor=#cccccc>
                  <b>Informacje o instrumencie<b></td></tr>";
      $numRecords = count($this->internalData[0]);
      for($i = 0; $i < $numRecords; $i++) {
         $instms = $this->internalData[0];
         $prices = $this->internalData[1];
         $years = $this->internalData[2];
         $html .= "<tr><td>$instms[$i]</td><td> $prices[$i]</td>
            <td>$years[$i]</td></tr>";
      }
      $html .= "</table><br>";
      echo $html;
   }
}

class FancyWidget extends Widget {

   function __construct() {
   }

   public function draw() {
      $html =
      "<table border=0 cellpadding=5 width=270 bgcolor=#6699BB>
         <tr><td colspan=3 bgcolor=#cccccc>
         <b><span class=blue>Najnowsze ceny<span><b>
         </td></tr>
         <tr><td><b>instrument</b></td>
         <td><b>cena</b></td><td><b>data produkcji</b>
         <td></tr>";

      $numRecords = count($this->internalData[0]);
      for($i = 0; $i < $numRecords; $i++) {
         $instms = $this->internalData[0];
         $prices = $this->internalData[1];
         $years = $this->internalData[2];

         $html .=
         "<tr><td>$instms[$i]</td><td>
            $prices[$i]</td><td>$years[$i]
            </td></tr>";
      }
      $html .= "</table><br>";
      echo $html;
   }
}

?>