<?php
   require_once('interface.Validator.php');

   abstract class PropertyObject implements Validator {

      protected $propertyTable = array();     // Przechowuje pary nazwa-warto
                                              // przypisujce wasnoci do
                                              // pl bazy danych
      protected $changedProperties = array(); // Lista wasnoci, ktre zostay
                                              // zmodyfikowane

      protected $data;                        // Dane z bazy danych

      protected $errors = array();            // Ewentualne bdy walidacji

      public function __construct($arData) {
         $this->data = $arData;
      }

      function __get($propertyName) {
      if(!array_key_exists($propertyName, $this->propertyTable))
         throw new Exception("Bdna wasno \"$propertyName\"!");

      if(method_exists($this, 'get' . $propertyName)) {
         return call_user_func(array($this, 'get' . $propertyName));
      } else {
         return $this->data[$this->propertyTable[$propertyName]];
      }
   }

   function __set($propertyName, $value) {
      if(!array_key_exists($propertyName, $this->propertyTable))
         throw new Exception("Bdna wasno \"$propertyName\"!");
      if(method_exists($this, 'set' . $propertyName)) {
         return call_user_func(
                               array($this, 'set' . $propertyName),
                               $value
                              );
      } else {

         // Jeli warto wasnoci ulega zmianie i nie ma jej
         // jeszcze w tabeli changedProperties, zostaje do niej doczona
         if($this->propertyTable[$propertyName] != $value &&
            !in_array($propertyName, $this->changedProperties)) {
            $this->changedProperties[] = $propertyName;
         }

         // Przypisuje now warto
         $this->data[$this->propertyTable[$propertyName]] = $value;

         }
      }

      function validate() {

      }

   }
?>