<?php
   require_once('class.PropertyObject.php');

   class Address extends PropertyObject {

      function __construct($addressid) {
         $arData = DataManager::getAddressData($addressid);

         parent::__construct($arData);

         $this->propertyTable['addressid'] = 'adres_id';
         $this->propertyTable['id'] = ' adres_id ';
         $this->propertyTable['entityid'] = 'jednostka_id';
         $this->propertyTable['address1'] = 'sadres1';
         $this->propertyTable['address2'] = 'sadres2';
         $this->propertyTable['city'] = 'smiasto';
         $this->propertyTable['zipcode'] = 'skod';
         $this->propertyTable['type'] = 'styp';
      }

      function validate() {
         if(strlen($this->zipcode) != 6) {
            $this->errors['zipcode'] = 'Naley poda poprawny kod pocztowy.';
         }

         if(!$this->address1) {
            $this->errors['address1'] = 'Adres to pole wymagane.';
         }

         if(!$this->city) {
            $this->errors['city'] = 'Miasto to pole wymagane.';
         }

         if(sizeof($this->errors)) {
            return false;
         } else {
            return true;
         }
      }

      function __toString() {
         return $this->address1 . ', ' .
            $this->address2 . ', ' .
            $this->city . ', ' .
            $this->zipcode;
      }
   }
?>