<?php

class Widget {
  
  private $id;
  private $name;
  private $description;  private $hDB;
  private $needsUpdating = false;
  
  public function __construct($widgetID) {
    //Parametr widgetID to klucz gwny rekordu 
    //w bazie danych, zawierajcego dane
    //tego obiektu

    //Tworzy uchwyt poczenia i zachowuje go w prywatnej zmiennej skadowej
    $this->hDB = pg_connect('dbname=parts user=postgres');
    if(! is_resource($this->hDB)) {
      throw new Exception('Nie mona poczy si z baz danych.');
    }
    
    $sql = "SELECT \"nazwa\", \"opis\" FROM artykul WHERE nr_artykuu = $widgetID";
    $rs = pg_query($this->hDB, $sql);
    if(! is_resource($rs)) {
      throw new Exception("Bd przy wykonywaniu instrukcji wyboru.");
    }
    
    if(! pg_num_rows($rs)) {
      throw new Exception('Szukanego artykuu nie ma w bazie!');
    }
        
    $data = pg_fetch_array($rs);
    $this->id = $widgetID;
    $this->name = $data['nazwa'];
    $this->description = $data['opis'];
    
  }
  
  public function getName() {
    return $this->name;
  }
  
  public function getDescription() {
    return $this->description;
  }
  
  public function setName($name) {
    $this->name = $name;
    $this->needsUpdating = true;
  }
  
  public function setDescription($description) {
    $this->description = $description;
    $this->needsUpdating = true;
  }
  
  public function __destruct() {
    if(! $this->needsUpdating) {
      return;
    }
    
    $sql = 'UPDATE "artykul" SET ';
    $sql .= "\"nazwa\" = '" . pg_escape_string($this->name) . "', ";
    $sql .= "\"opis\" = '" . pg_escape_string($this->description) . "' ";
    $sql .= "WHERE nr_artykulu = " . $this->id;
    
    $rs = pg_query($this->hDB, $sql);
    if(! is_resource($rs)) {
      throw new Exception('Wystpi bd podczas aktualizacji bazy danych');
    }
    
    //Koniec operacji na bazie danych. Zamkmnicie poczenia.
    pg_close($this->hDB);
  }
}
?>
