<?php
   require_once('class.PropertyObject.php');

   class PhoneNumber extends PropertyObject {
      function __construct($phoneid) {
         $arData = DataManager::getPhoneNumberData($phoneid);

         parent::__construct($arData);

         $this->propertyTable['phoneid'] = 'telefon_id';
         $this->propertyTable['id'] = 'telefon_id';
         $this->propertyTable['entityid'] = 'jednostka_id';
         $this->propertyTable['number'] = 'snumer';
         $this->propertyTable['extension'] = 'swewnetrzny';
         $this->propertyTable['type'] = 'styp';
      }

      function validate() {
         if(!$this->number) {
            $this->errors['number'] = 'Numer telefonu jest wymagany.';
         }

         if(sizeof($this->errors)) {
            return false;
         } else {
            return true;
         }
      }

      function __toString() {
         return $this->number .
            ($this->extension ? ' x' . $this->extension : '');
      }
   }
?>