class RSS extends DomDocument {
    function __construct($tytul, $odnosnik, $opis) {
        // Ustaw ten dokument jako XML 1.0 elementem nadrzdnym
        // <rss>, ktry posiada atrybut version="0.91".
        parent::__construct('1.0');
        $rss = $this->createElement('rss');
        $rss->setAttribute('version', '0.91');
        $this->appendChild($rss);

        // Utwrz element <channel> zawierajcy podelementy <title>, <link>,
        // i <description>.
        $channel = $this->createElement('channel');
        $channel->appendChild($this->tworzWezelTekstowy('title', $tytul));
        $channel->appendChild($this->tworzWezelTekstowy('link', $odnosnik));
        $channel->appendChild($this->tworzWezelTekstowy('description',
                                                  $opis));

        // Dodaj element <channel> jako podelement <rss>.
        $rss->appendChild($channel);

        // Ustaw wywietlanie danych wyjciowych ze znakami nowego wiersza
        // oraz znakami odstpu.
        $this->formatOutput = true;
    }

    // Ta funkcja dodaje element <item> do elementu <channel>.
    function dodajElement($tytul, $odnosnik, $opis) {
        // Utwrz element <channel> zawierajcy podelementy <title>, <link>,
        // i <description>.
        $pozycja->appendChild($this->tworzWezelTekstowy('title', $tytul));
        $pozycja->appendChild($this->tworzWezelTekstowy('link', $odnosnik));
        $pozycja->appendChild($this->tworzWezelTekstowy('description',
                                               $opis));

        // Dodaj element <channel> jako podelement <rss>.
        $channel = $this->getElementsByTagName('channel')->pozycja(0);
        $channel->appendChild($pozycja);
    }

    // Funkcja pomocnicza, dziki ktrej elementy skadaj si w caoci
    // z tekstu (brak podelementw).
    private function tworzWezelTekstowy($nazwa, $tekst) {
        $element = $this->createElement($nazwa);
        $element->appendChild($this->createTextNode($tekst));
        return $element;
    }
}

// Utwrz now wiadomo RSS z okrelonym tytuem, odnonikiem i opisem
// wybranego kanau.
$rss = new RSS("Co jest na obiad?", 'http://menu.przyklad.com/',
               'Poniej znajduj si moliwe do wyboru posiki na wieczr.');
// Dodaj trzy elementy.
$rss->dodajElement('Duszona ryba',
              'http://menu.przyklad.com/potrawy.php?potrawa=ryba',
              'Delikatny owoc morza, ktry Ci poywi i pokrzepi.');
$rss->dodajElement('Pieczone podroby drobiowe ze sol',
              'http://menu.przyklad.com/potrawy.php?potrawa=podroby',
              'Bogata w tuszcze i wglowodany potrawa parzona z sol i przyprawami.');
$rss->dodajElement('Ucho morskie z kabaczkiem oraz kacz nok',
              'http://menu.przyklad.com/potrawy.php?potrawa=uchowiec',
              "Nie mona pomyli tej wyjtkowej przyjemnoci pyncej z konsumpcji ucha morskiego.");
// Wywietl XML.
print $rss->saveXML();
