<?php
// Wczytaj bibliotek QuickForm.
require 'HTML/QuickForm.php';
// Utwrz obiekt formularza.
$formularz = new HTML_QuickForm();

// Zdefiniowanie takich samych tablic poprawnoci sodyczy i gwnych potraw.
$slodycze = array('sezam' => 'Francuskie ciasto z sezamem',
                'kokos' => 'elatynowe mleczko kokosowe',
                'ciasto' => 'Ciasto z brzowym cukrem',
                'ryzmieso' => 'Sodki ry z misem');

$glowna_potrawa = array('ryba' => 'Duszona ryba',
                     'zoladek' => "Smaone odki",
                     'flaki' => 'Smaone flaki z sosem winnym',
                     'taro' => 'Duszona wieprzowina z taro',
                     'drob' => 'Pieczone podroby drobiowe z sol',
                     'uchowiec' => 'Ucho morskie z kabaczkiem oraz kacz nok');

// Ustaw wartoci domylne z elementw formularza.
$formularz->setDefaults(array('dostawa' => 'tak',
                         'wielkosc'     => 'rednia'));

// Dodaj kady element do formularza.
$formularz->addElement('text','nazwisko','Podaj imi: ');
$formularz->addElement('radio','wielkosc','Porcja:','Ma', 'maly');
$formularz->addElement('radio','wielkosc','',     'redni', 'sredni');
$formularz->addElement('radio','wielkosc','',     'Du', 'duzy');

$formularz->addElement('select','slodycz','Wybierz jeden rodzaj sodyczy:', $slodycze);
$formularz->addElement('select','glowna_potrawa','Wybierz dwie gwne potrawy:',
                  $glowna_potrawa, 'multiple="multiple"');

$formularz->addElement('radio','dostawa','Czy chcesz, aby Twoje zamwienie zostao dostarczone?',
                  'Tak','tak');

$formularz->addElement('textarea','komentarze','Podaj tutaj informacje dodatkowe. <br/>
    Jeeli chcesz, aby Twoje zamwienie zostao dostarczone, umie tutaj swj adres:');

$formularz->addElement('submit','zapisz','Zamawiam');

// Utworzenie dwch wasnych zasad sprawdzania poprawnoci (zaimplementowane
// przez funkcje dodan na kocu skryptu).
$formularz->registerRule('sprawdz_tablice','funkcja','sprawdz_tablice');
$formularz->registerRule('sprawdz_wielkosc_tablicy','funkcja','sprawdz_wielkosc_tablicy');

// Pole "nazwisko" jest wymagane.
$formularz->addRule('nazwisko','Prosz poda swoje nazwisko.','required');
// Pole "wielkosc" jest wymagane i musi posiada jedn z podanych
// wartoci: "maly", "sredni", or "duzy".
$formularz->addRule('wielkosc','Prosz poda wielko.','required');
$formularz->addRule('wielkosc','Prosz poda wielko.','sprawdz_tablice',
               array('maly' => 1, 'sredni' => 1, 'duzy' => 1));

// Pole "slodycz" jest wymagane, a jego warto musi
// znajdowa si w tablicy $slodycze.
$formularz->addRule('slodycz','Prosz wybra poprawny element sodycz.','required');
$formularz->addRule('slodycz','Prosz wybra poprawny element sodycz.', 'sprawdz_tablice',
               $slodycze);

// Pole "glowna_potrawa" jest wymagane, musi posiada dokadnie dwie wartoci,
// a te wartoci musz znajdowa si w tablicy $glowna_potrawa.
$formularz->addRule('glowna_potrawa','Prosz zaznaczy dokadnie dwie gowne potrawy.',
               'required');
$formularz->addRule('glowna_potrawa','Prosz zaznaczy dokadnie dwie gowne potrawy.',
               'sprawdz_wielkosc_tablicy', 2);
$formularz->addRule('glowna_potrawa','Prosz zaznaczy dokadnie dwie gowne potrawy.',
               'sprawdz_tablice', $glowna_potrawa);

// Gwna logika strony brzmi: jeeli wysane parametry formularza s poprawne,
// wwczas przetwrz je, uruchamiajc funkcj zapisz_zamowienie().
// W przeciwnym przypadku wywietl formularz.
if ($formularz->validate()) {
    $formularz->process('zapisz_zamowienie');
} else {
    $formularz->display();
}

// Funkcja przeprowadzajca przetwarzanie formularza. Rni si od funkcji
// przetworz_formularz() z rozdziau 6.  tylko tym, e pozwala na dostp
// do wysanych parametrw formularza dziki zmiennej $dane_formularza zamiast $_POST.
function zapisz_zamowienie($dane_formularza) {
    // Odszukaj pene nazwy sodyczy i gwnych potraw
    // w tablicach $GLOBALS['slodycze'] i $GLOBALS['glowna_potrawa'].
    $slodycz = $GLOBALS['slodycze'][ $dane_formularza['slodycz'] ];
    $glowna_potrawa_1 = $GLOBALS['glowna_potrawa'][ $dane_formularza['glowna_potrawa'][0] ];
    $glowna_potrawa_2 = $GLOBALS['glowna_potrawa'][ $dane_formularza['glowna_potrawa'][1] ];
    if ($dane_formularza['dostawa'] == 'tak') {
        $dostawa = 'Zdecydowae';
    } else {
        $dostawa = 'Nie zdecydowae';
    }
    // Budowanie tekstu wiadomoci zamwienia.
    $wiadomosc=<<<_ZAMOWIENIE_
Szanowny $dane_formularza[nazwisko]! Dzikujemy za zoenie zamwienia.
Zamwie $dane_formularza[wielkosc] porcj nastpujcych potraw: $slodycz, $glowna_potrawa_1 i $glowna_potrawa_2.
$dostawa si na dostaw zamwienia.
_ZAMOWIENIE_;
    if (strlen(trim($dane_formularza['komentarze']))) {
        $wiadomosc .= 'Twj komentarz: '.$dane_formularza['komentarze'];
    }

    // Wylij wiadomo do szefa.
    mail('szef@restauracja.przyklad.com', 'Nowe zamwienie', $wiadomosc);
    // Wywietl zamwienia, ale zakoduj wszelkie encje HTML
    // i wcz znaki nowego wiersza <br/>.
    print nl2br(htmlentities($wiadomosc));
}

// Pomocnicze funkcje kontrolujce, czy zmienna
// $wartosc_parametru jest kluczem w tablicy $tablica (lub czy kada warto
// w $wartosc_parametru jest kluczem w tablicy $tablica, jeli $wartosc_parametru
// jest tablic).
function sprawdz_tablice($nazwa_parametru, $wartosc_parametru, $tablica) {
    if (is_array($wartosc_parametru)) {
        foreach ($wartosc_parametru as $wyslana_wartosc) {
            if (! array_key_exists($wyslana_wartosc, $tablica)) {
                return false;
            }
        }
        return true;
    } else {
        return array_key_exists($wartosc_parametru, $tablica);
    }
}

function sprawdz_wielkosc_tablicy($nazwa_parametru, $wartosc_parametru, $wielkosc) {
    return count($wartosc_parametru) == $wielkosc;
}
?>
