// Wartoci zostay podane w punktach (1/72 cala).
$rozmiar_czcionki = 72;     // Jeden cal wysokoci liter.
$wysokosc_strony = 612; // Wysoko strony to 8,5 cala.
$szerokosc_strony = 792;  // Szeroko strony to 1 cali.

// Jeeli komunikat nie zostanie podany, uyj domylnego.
if (strlen(trim($_GET['komunikat']))) {
    $komunikat = trim($_GET['komunikat']);
} else {
    $komunikat = 'Generuj dokument PDF!';
}

// Utwrz nowy dokument PDF w pamici.
$pdf = pdf_new();
pdf_open_file($pdf, '');

// Dodaj do dokumentu stron o wymiarach 11"x8.5".
pdf_begin_page($pdf, $szerokosc_strony, $wysokosc_strony);

// Zaznacz czcionk Helvetica o wysokoci 72 punktw.
$czcionka = pdf_findfont($pdf, "Helvetica", "winansi", 0);
pdf_setfont($pdf, $czcionka, $rozmiar_czcionki);

// Wywietl komunikat centralnie na stronie.
pdf_show_boxed($pdf, $komunikat, 0, ($wysokosc_strony-$rozmiar_czcionki)/2,
               $szerokosc_strony, $rozmiar_czcionki, 'center');

// Zakocz stron oraz dokument.
pdf_end_page($pdf);
pdf_close($pdf);

// Pobierz zawarto dokumentu i usu j z pamici.
$pdf_doc = pdf_get_buffer($pdf);
pdf_delete($pdf);

// Wylij odpowiednie nagwki oraz zawarto dokumentu.
header('Content-Type: application/pdf');
header('Content-Length: ' . strlen($pdf_doc));
print $pdf_doc;
