<?php
// Uyj funkcji pomocniczych formularza zdefiniowanych w rozdziale 6.
require 'funkcje_pomocnicze.php';

$miesiace = array(1 => 'Stycze', 2 => 'Luty', 3 => 'Marzec', 4 => 'Kwiecie',
                5 => 'Maj', 6 => 'Czerwiec', 7 => 'Lipiec', 8 => 'Sierpie',
                9 => 'Wrzesie', 10 => 'Padziernik', 11 => 'Listopad',
                12 => 'Grudzie');

$lata = array();
for ($rok = date('Y') - 1, $max_rok = date('Y') + 5; $rok < $max_rok; $rok ++) {
    $lata [$rok] = $rok;
}

if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy = sprawdz_formularz()) {
        pokaz_formularz($bledy);
    } else {
        pokaz_formularz();
        przetworz_formularz();
    }
} else {
    // Jeeli nic nie zostao wysane, poka formularz, a nastpnie
    // kalendarz dla biecego miesica.
    pokaz_formularz();
    pokaz_kalendarz(date('n'), date('Y'));
}

function sprawdz_formularz() {
    global $miesiace, $lata;
    $bledy = array();

    if (! array_key_exists($_POST['miesiac'], $miesiace)) {
        $bledy[] = 'Zaznacz poprawny miesic.';
    }

    if (! array_key_exists($_POST['rok'], $lata)) {
        $bledy[] = 'Zaznacz poprawny rok.';
    }

    return $bledy;
}

function pokaz_formularz($bledy = '') {
    global $miesiace, $lata, $ten_rok;

    // Jeeli formularz zosta wysany, pobierz wartoci domylne
    // z wysanych zmiennych formularza.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym przypadku ustaw wasne wartoci domylne:
        // biecy miesic i rok.
        $domyslne = array('rok' => date('Y'),
                          'miesiac' => date('n'));
    }


    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    wprowadz_menu('miesiac', $domyslne, $miesiace);
    wprowadz_menu('rok',  $domyslne, $lata);
    przycisk_wyslij('submit','Poka kalendarz');
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function przetworz_formularz() {
    pokaz_kalendarz($_POST['miesiac'], $_POST['rok']);
}

function pokaz_kalendarz($miesiac, $rok) {
    global $miesiace;
    $dni_tygodnia = array('N', 'Pn', 'Wt', 'r', 'Cz', 'Pt', 'So');

    // Znajd czas od pocztku epoki dla pnocy pierwszego dnia miesica.
    $pierwszy_dzien = mktime(0,0,0,$miesiac, 1, $rok);
    // Ile dni jest w tym miesicu?
    $dni_w_miesiacu = date('t', $pierwszy_dzien);
    // Ktry dzie tygodnia (liczbowo) jest pierwszym dniem miesica?
    // Potrzebujesz tego, aby umieci pierwsz komrk tabeli w odpowiednim miejscu.
    $pozycja_dnia = date('w', $pierwszy_dzien);


    // Wywietl nagwek tabeli i wiersz z nazwami dni tygodnia.
    print<<<_HTML_
<table border="0" cellspacing="0" cellpadding="2">
<tr><th colspan="7">$miesiace[$miesiac] $rok</th></tr>
<tr><td align="center">
_HTML_;
    print implode('</td><td align="center">', $dni_tygodnia);
    print '</td></tr>';


    // Jeeli pierwszym dniem tygodnia jest, powiedzmy, wtorek, wwczas
    // musisz umieci puste komrki tabeli pod "N" i "Pn" w pierwszym
    // wierszu, aby komrka tabeli z dniem pierwszym bya pod "Wt".
    if ($pozycja_dnia > 0) {
        for ($i = 0; $i < $pozycja_dnia; $i++) { print '<td>&nbsp;</td>'; }
    }

    // Wywietl komrk tabeli dla kadego dnia miesica.
    for ($dzien = 1; $dzien <= $dni_w_miesiacu; $dzien++ ) {
        print '<td align="center">' . $dzien. '</td>';
        $pozycja_dnia++;
        // Jeeli ta komrka bya sidm w wierszu, wwczas
        // zakocz wiersz tabeli i wyzeruj zmienn $pozycja_dnia.
        if ($pozycja_dnia == 7) {
            $pozycja_dnia = 0;
            print "</tr>\n";
            // Jeeli nie ma wikszej iloci dni, wwczas
            // rozpocznij nowy wiersz tabeli.
            if ($dzien < $dni_w_miesiacu) {
                print '<tr>';
            }
        }
    }

    // W tym momencie dla kadego dnia miesica zostaa wywietlona
    // jedna komrka tabeli. Jeeli ostatnim dniem miesica nie jest sobota,
    // wwczas ostatni wiersz tabeli trzeba uzupeni za pomoc
    // kilku pustych komrek a do koca wiersza.
    if ($pozycja_dnia > 0) {
        for ($i = $pozycja_dnia; $i < 7; $i++) {
            print '<td>&nbsp;</td>';
        }
        print '</tr>';
    }
    print '</table>';
}
?>
