<?php
require 'funkcje_pomocnicze.php';

// Ustawienie tablic miesicy, dni, lat, godzin i minut.
$miesiace = array(1 => 'Stycze', 2 => 'Luty', 3 => 'Marzec', 4 => 'Kwiecie',
                5 => 'Maj', 6 => 'Czerwiec', 7 => 'Lipiec', 8 => 'Sierpie',
                9 => 'Wrzesie', 10 => 'Padziernik', 11 => 'Listopad',
                12 => 'Grudzie');

$dni = array();
for ($i = 1; $i <= 31; $i++) { $dni [$i] = $i; }

$lata = array();
for ($rok = date('Y') -1, $max_rok = date('Y') + 5; $rok < $max_rok; $rok++) {
    $lata[$rok] = $rok;
}

$godziny = array();
for ($godzina = 1; $godzina <= 12; $godzina ++) { $godziny[$godzina] = $godzina; }

$minuty = array();
for ($minuta = 0; $minuta < 60; $minuta +=5) {
    $sformatowana_minuta = sprintf('%02d', $minuta);
    $minuty[$sformatowana_minuta] = $sformatowana_minuta;
}

if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy, przeka je do pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic przetwrz je.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic wywietl go.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $godziny, $minuty, $miesiace, $dni, $lata;

    // Jeeli formularz zosta wysany, pobierz wartoci domylne z wysanych zmiennych.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym przypadku ustaw wasne wartoci domylne:
        // biecy czas i czci daty.
        $domyslne = array('godzina'  => date('g'),
                          'ampm'  => date('a'),
                          'miesiac' => date('n'),
                          'dzien'   => date('j'),
                          'rok'  => date('Y'));

        // Poniewa dostpne moliwoci wyboru minuty z menu s w piciominutowych odstpach,
        // jeeli bieca minuta nie jest wielokrotnoci piciu,
        // musimy j uczyni tak wielokrotnoci.
        $ta_minuta = date('i');
        $minuta_mod_piec = $ta_minuta % 5;
        if ($minuta_mod_piec != 0) { $ta_minuta -= $minuta_mod_piec;  }
        $domyslne['minuta'] = sprintf('%02d', $ta_minuta);
    }

    // Jeeli zostay przekazane bdy, umie je w zmiennej $tekst_bledu
    // (ze znacznikami HTML).
    if ($bledy) {
        print 'Musisz poprawi nastujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print 'Podaj dat i czas:';

    wprowadz_menu('godzina',$domyslne,$godziny);
    print ':';
    wprowadz_menu('minuta',$domyslne,$minuty);
    wprowadz_menu('ampm', $domyslne,array('am' => 'am', 'pm' => 'pm'));
    wprowadz_menu('miesiac',$domyslne,$miesiace);
    print ' ';
    wprowadz_menu('dzien',$domyslne,$dni);
    print ' ';
    wprowadz_menu('rok',$domyslne,$lata);
    print '<br/>';
    przycisk_wyslij('submit','Znajd spotkanie');
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    global $godziny, $minuty, $miesiace, $dni, $lata;

    $bledy = array();

    if (! array_key_exists($_POST['miesiac'], $miesiace)) {
        $bledy[] = 'Zaznacz poprawny miesic.';
    }
    if (! array_key_exists($_POST['dzien'], $dni)) {
        $bledy[] = 'Zaznacz poprawny dzie.';
    }
    if (! array_key_exists($_POST['rok'], $lata)) {
        $bledy[] = 'Zaznacz poprawny rok.';
    }
    if (! array_key_exists($_POST['godzina'], $godziny)) {
        $bledy[] = 'Zaznacz poprawn godzin.';
    }
    if (! array_key_exists($_POST['minuta'], $minuty)) {
        $bledy[] = 'Zaznacz poprawn minut.';
    }
    if (($_POST['ampm'] != 'am') && ($_POST['ampm'] != 'pm')) {
        $bledy[] = 'Zaznacz poprawny wybr am/pm.';
    }

    return $bledy;
}

function przetworz_formularz() {

    // Zanim bdziemy mogli przekaza parametry do funkcji mktime(), musimy
    // przekonwertowa godzin na zapis 24-godzinny, uwzgldniajc wpyw am/pm z
    // $_POST['ampm'].

    if (($_POST['ampm'] == 'am') && ($_POST['godzina'] == 12)) {
        // 12 am to godzina 0 w zapisie 24-godzinnym.
        $_POST['godzina'] = 0;
    } elseif (($_POST['ampm'] == 'pm') && ($_POST['godzina'] != 12)) {
        // Dla czasu pm, z wyjtkiem 12 pm, dodaj 12 do godziny,
        // 1 pm staje si 13, 11 pm staje si 23, ale 12 pm (poudnie)
        // pozostaje 12.
        $_POST['godzina'] += 12;
    }

    // Utwrz czas od pocztku epoki dla czasu podanego przez uytkownika.
    $znacznik_czasu = mktime($_POST['godzina'], $_POST['minuta'], 0,
                        $_POST['miesiac'], $_POST['dzien'], $_POST['rok']);

    // Jak okreli dat kolejnego spotkania NYPHP po dacie podanej przez uytkownika:
    // Jeeli $znacznik_czasu jest w czwartym wtorku miesica lub przed nim,
    // wwczas uyj daty spotkania NYPHP dla miesica $znacznik_czasu.
    // W przeciwnym przypadku uyj daty spotkania NYPHP w nastpnym miesicu.

    // Pnoc w dacie podanej przez uytkownika.
    $polnoc  = mktime(0,0,0, $_POST['miesiac'], $_POST['dzien'], $_POST['rok']);
    // Pnoc w pierwszym miesicu podanym przez uytkownika.
    $pierwszy_dzien_miesiaca = mktime(0,0,0,$_POST['miesiac'],1,$_POST['rok']);
    // Pnoc w czwarty wtorek miesica podany przez uytkownika.
    $miesiac_nyphp = strtotime('fourth thursday',$pierwszy_dzien_miesiaca);

    if ($polnoc  < $miesiac_nyphp) {
        // Data podana przez uytkownika jest przed dniem spotkania.
        print "Spotkanie NYPHP w biecym miesicu: ";
        print date('l, F j, Y', $miesiac_nyphp);
    } elseif ($polnoc  == $miesiac_nyphp) {
        // Data podana przez uytkownika jest dniem spotkania.
        print "Spotkanie NYPHP ma miejsce dzisiaj. ";
        $poczatek_spotkania = strtotime('6:30pm', $miesiac_nyphp);
        // Jeeli jest po godzinie 6:30 pm, poinformuj, e spotkanie si ju rozpoczo.
        if ($znacznik_czasu > $poczatek_spotkania) {
            print "Spotkanie rozpoczo si o godzinie 18:30 ";
            print date('g:i a', $znacznik_czasu);
        }
    } else {
        // Data podana przez uytkownika jest po dniu spotkania, wic
        // znajd dzie spotkania w kolejnym miesicu.
        $pierwszy_dzien_kolejnego_miesiaca = mktime(0,0,0,$_POST['miesiac'] + 1,1,$_POST['rok']);
        $nastepny_miesiac_nyphp = strtotime('fourth thursday',$pierwszy_dzien_kolejnego_miesiaca);
        print "Spotkanie NYPHP w nastpnym miesicu: ";
        print date('l, F j, Y', $nastepny_miesiac_nyphp);
    }
}
?>
