require 'funkcje_pomocnicze.php';

$miesiace = array(1 => 'Stycze', 2 => 'Luty', 3 => 'Marzec', 4 => 'Kwiecie',
                5 => 'Maj', 6 => 'Czerwiec', 7 => 'Lipiec', 8 => 'Sierpie',
                9 => 'Wrzesie', 10 => 'Padziernik', 11 => 'Listopad',
                12 => 'Grudzie');

$lata = array();
for ($rok = date('Y'), $max_rok = date('Y') + 10; $rok < $max_rok; $rok++) {
    $lata[$rok] = $rok;
}

if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        process_form();
    }
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    print '<form method="POST" action="' . $_SERVER['PHP_SELF'] . '">';

    print 'Data wanoci: ';
    wprowadz_menu('miesiac',$_POST,$GLOBALS['miesiace']);
    print ' ';
    wprowadz_menu('rok', $_POST,$GLOBALS['lata']);
    print '<br/>';
    przycisk_wyslij('submit','Sprawd dat wanoci');

    // Ukryta zmienna _sprawdz_czy_wyslac i kocwka formularza.
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Upewnij si, e zostay podane prawidowe: miesic i rok.
    if (! array_key_exists($_POST['miesiac'], $GLOBALS['miesiace'])) {
        $bledy[] = 'Prosz poda poprawny miesic.';
    }
    if (! array_key_exists($_POST['rok'], $GLOBALS['lata'])) {
        $bledy[] = 'Prosz poda poprawny rok.';
    }
    // Upewnij si, e miesic i rok s biecymi
    // lub pniejszymi.
    $ten_miesiac = date('n');
    $ten_rok  = date('Y');

    if ($_POST['rok'] < $ten_rok) {
        // Jeeli podany rok jest wczeniejszy, wwczas okres wanoci
        // karty kredytowej upyn.
        $bledy[] = 'Okres wanoci karty kredytowej ju upyn.';

    } elseif (($_POST['rok'] == $ten_rok) &&
              ($_POST['miesiac'] < $ten_miesiac)) {
        // Jeeli podany rok jest biecym rokiem, a podany miesic
        // jest wczeniejszym miesicem, wwczas okres wanoci karty kredytowej upyn.
        $bledy[] = 'Okres wanoci karty kredytowej ju upyn.';
    }

    return $bledy;
}

function przetworz_formularz() {
    print "Zosta podany poprawny okres wanoci karty.";
}
