<?php
require 'funkcje_pomocnicze.php';

// Jest to identyczne z funkcj wprowadz_tekst() z pliku funkcje_pomocnicze.php, ale
// wywietla pole hasa (w ktrym gwiazdki zasaniaj wpisywany tekst)
// zamiast zwykego pola tekstowego.
function wprowadz_haslo($nazwa_pola, $wartosci) {
    print '<input type="password" name="' . $nazwa_pola .'" value="';
    print htmlentities($wartosci[$nazwa_pola]) . '">';
}

session_start();

if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        przetworz_formularz();
    }
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';

    if ($bledy) {
        print '<ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }
    print 'Nazwa uytkownika: ';
    wprowadz_tekst('nazwa_uzytkownika', $_POST);
    print '<br/>';

    print 'Haso: ';
    wprowadz_haslo('haslo', $_POST);
    print '<br/>';

    przycisk_wyslij('submit','Zaloguj');

    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Kilka przykadowych nazw uytkownikw i hase.
    $uzytkownicy = array('alicja'   => 'pies123',
                         'bartek'     => 'mje^hlo',
                         'czarek' => '**zabawa**');

    // Upewnij si, e nazwa uytkownika jest poprawna.
    if (! array_key_exists($_POST['nazwa_uzytkownika'], $uzytkownicy)) {
        $bledy[] = 'Prosz poda poprawn nazw uytkownika i haso.';
    }

    // Sprawd, czy haso jest prawidowe.
    $zapisane_haslo = $uzytkownicy[ $_POST['nazwa_uzytkownika'] ];
    if ($zapisane_haslo != $_POST['haslo']) {
        $bledy[] = 'Prosz poda poprawn nazw uytkownika i haso.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Dodaj nazw uytkownika do sesji.
    $_SESSION['nazwa_uzytkownika'] = $_POST['nazwa_uzytkownika'];

    print "Witamy, $_SESSION[nazwa_uzytkownika]";
}
?>
