function przetworz_formularz() {
    // Dostp do zmiennej globalnej $db wewntrz tej funkcji.
    global $db;

    // Budowanie zapytania.
    $sql = 'SELECT nazwa_potrawy, cena, czy_ostra FROM potrawy WHERE ';

    // Dodanie ceny minimalnej do zapytania.
    $sql .= "cena >= '" .
            mysqli_real_escape_string($db, $_POST['cena_min']) . "' ";

    // Dodanie ceny maksymalnej do zapytania.
    $sql .= " AND cena <= '" .
            mysqli_real_escape_string($db, $_POST['cena_max']) . "' ";

    // Jeeli nazwa potrawy zostaa wysana, dodaj do klauzuli WHERE
    //  funkcje quoteSmart() i strtr(), aby zapobiec dziaaniu
    // wprowadzonych przez uytkownika znakw wieloznacznych.
    if (strlen(trim($_POST['nazwa_potrawy']))) {
        $potrawa = mysqli_real_escape_string($db, $_POST['nazwa_potrawy']);
        $potrawa = strtr($potrawa, array('_' => '\_', '%' => '\%'));
        // mysqli_real_escape_string() nie dodaj znakw pojedynczego cudzysowu
        // wok wartoci, a wic powiniene umieci je wok $potrawa
        // w zapytaniu:
        $sql .= " AND nazwa_potrawy LIKE '$potrawa'";
    }

    // Jeeli parametr czy_ostra ma warto "tak" lub "nie", dodaj odpowiednie SQL
    // (jeli warto wynosi "obojtnie", nie musimy dodawa parametru czy_ostra
    // do klauzuli WHERE).
    $wybor_ostrosci = $GLOBALS['dostepne_ostrosci'][ $_POST['czy_ostra'] ];
    if ($wybor_ostrosci == 'tak') {
        $sql .= ' AND czy_ostra = 1';
    } elseif ($wybor_ostrosci == 'nie') {
        $sql .= ' AND czy_ostra = 0';
    }

    // Wylij zapytanie do programu bazy danych i pobierz z powrotem wszystkie wiersze.
    $q = mysqli_query($db, $sql);

    if (mysqli_num_rows($q) == 0) {
        print 'Nie znaleziono adnych odpowiadajcych potraw.';
    } else {
        print '<table>';
        print '<tr><th>Nazwa potrawy</th><th>Cena</th><th>Ostro?</th></tr>';
        while ($potrawa = mysqli_fetch_object($q)) {
            if ($potrawa->czy_ostra == 1) {
                $ostrosc = 'Tak';
            } else {
                $ostrosc = 'Nie';
            }
            printf('<tr><td>%s</td><td>$%.02f</td><td>%s</td></tr>',
                   htmlentities($potrawa->nazwa_potrawy), $potrawa->cena, $ostrosc);
        }
    }
}
