<?php

// Wczytaj PEAR DB.
require 'DB.php';
// Wczytaj funkcje pomocnicze formularza.
require 'funkcje_pomocnicze.php';

// Nawi poczenie z baz danych.
$db = DB::connect('mysql://mysliwy:w)mp3s@db.przyklad.com/restauracja');
if (DB::isError($db)) { die ("Nie mog nawiza poczenia: " . $db->getMessage()); }

// Ustaw automatyczn obsug bdw.
$db->setErrorHandling(PEAR_ERROR_DIE);

// Ustaw tryb pobierania: wiersze jako obiekty.
$db->setFetchMode(DB_FETCHMODE_OBJECT);

// Moliwe wybory dla menu "ostrosc" w formularzu.
$dostepne_ostrosci = array('nie','tak','obojtne');

// Warstwa logiczna strony gwnej:
// - Jeeli formularz zosta wysany, sprawd jego poprawno, a nastpnie przetwrz
// - lub wywietl ponownie.
// - Jeeli formularz nie zosta wysany, wywietl go.
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, a wic przetwrz je.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, a wic wywietl go.
    pokaz_formularz();
}

function pokaz_formularz($errors = '') {
    // Jeeli formularz zosta wysany,
    // pobierz wartoci domylne z wysanych parametrw.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym przypadku ustaw wasne wartoci domylne.
        $domyslne = array('cena_min' => '5.00',
                          'cena_max' => '25.00');
    }

    // Jeeli zostay przekazane bdy,
    // umie je w zmiennej $tekst_bledu (ze znacznikami HTML).
    if (is_array($bledy)) {
        $tekst_bledu = '<tr><td>Musisz poprawi nastpujce bdy:';
        $tekst_bledu .= '</td><td><ul><li>';
        $tekst_bledu .= implode('</li><li>',$bledy);
        $tekst_bledu .= '</li></ul></td></tr>';
    } else {
        // Nie wystpiy bdy? Wwczas zmienna $tekst_bledu jest pusta.
        $tekst_bledu = '';
    }

    // Wyskakujemy z trybu PHP, aby uatwi wywietlanie znacznikw HTML.
?>
<form method="POST" action="<?php print $_SERVER['PHP_SELF']; ?>">
<table>
<?php print $tekst_bledu?>

<tr><td>Nazwa potrawy:</td>
<td><?php input_text('nazwa_potrawy', $domyslne) ?></td></tr>

<tr><td>Cena minimalna:</td>
<td><?php input_text('cena_min', $domyslne) ?></td></tr>

<tr><td>Cena maksymalna:</td>
<td><?php input_text('cena_max', $domyslne) ?></td></tr>

<tr><td>Ostro potrawy:</td>
<td><?php input_select('czy_ostra', $domyslne, $GLOBALS['dostepne_ostrosci']); ?>
</td></tr>

<tr><td colspan="2" align="center"><?php input_submit('szukaj','Szukaj'); ?>
</td></tr>

</table>
<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>
</form>
<?php
      } // Koniec funkcji pokaz_formularz().

function sprawdz_formularz() {
    $bledy = array();

    // Cena minimalna musi by poprawn liczb zmiennoprzecinkow.
    if ($_POST['cena_min'] != strval(floatval($_POST['cena_min']))) {
        $bledy[] = 'Prosz poda poprawn cen minimaln.';
    }

    // Cena maksymalna musi by poprawn liczb zmiennoprzecinkow.
    if ($_POST['cena_max'] != strval(floatval($_POST['cena_max']))) {
        $bledy[] = 'Prosz poda poprawn cen maksymaln.';
    }

    // Cena minimalna musi by nisza od ceny maksymalnej.
    if ($_POST['cena_min'] >= $_POST['cena_max']) {
        $bledy[] = 'Cena minimalna musi by nisza od ceny maksymalnej.';
    }

    if (! array_key_exists($_POST['czy_ostra'], $GLOBALS['dostepne_ostrosci'])) {
        $bledy[] = 'Prosz wybra poprawn opcj "ostro".';
    }
    return $bledy;
}

function przetworz_formularz() {
    // Dostp do zmiennej globalnej $db wewntrz tej funkcji.
    global $db;

    // Budowanie zapytania.
    $sql = 'SELECT nazwa_potrawy, cena, czy_ostra FROM potrawy WHERE
            cena >= ? AND cena <= ?';

    // Jeeli nazwa potrawy zostaa wysana, dodaj do klauzuli WHERE
    // funkcje quoteSmart() i strtr(), aby zapobiec dziaaniu
    // wprowadzonych przez uytkownika znakw wieloznacznych.
    if (strlen(trim($_POST['nazwa_potrawy']))) {
        $potrawa = $db->quoteSmart($_POST['nazwa_potrawy']);
        $potrawa = strtr($potrawa, array('_' => '\_', '%' => '\%'));
        $sql .= " AND nazwa_potrawy LIKE $potrawa ";
    }

    // Jeeli parametr czy_ostra ma warto "tak" lub "nie", dodaj odpowiednie SQL
    // (jeli warto wynosi "obojtnie", nie musimy dodawa parametru czy_ostra
    // do klauzuli WHERE).
    $wybor_ostrosci = $GLOBALS['dostepne_ostrosci'][ $_POST['czy_ostra'] ];
    if ($wybor_ostrosci == 'tak') {
        $sql .= ' AND czy_ostra = 1';
    } elseif ($wybor_ostrosci == 'nie') {
        $sql .= ' AND czy_ostra = 0';
    }

    // Wylij zapytanie do programu bazy danych i pobierz z powrotem wszystkie wiersze.
    $potrawy = $db->getAll($sql, array($_POST['cena_min'],
                                      $_POST['cena_max']));

    if (count($potrawy) == 0) {
        print 'Nie znaleziono adnych odpowiadajcych potraw.';
    } else {
        print '<table>';
        print '<tr><th>Nazwa potrawy</th><th>Cena</th><th>Ostro?</th></tr>';
        foreach ($potrawy as $potrawa) {
            if ($potrawa->czy_ostra == 1) {
                $ostrosc = 'Tak';
            } else {
                $ostrosc = 'Nie';
            }
            printf('<tr><td>%s</td><td>$%.02f</td><td>%s</td></tr>',
                   htmlentities($potrawa->nazwa_potrawy), $potrawa->cena, $ostrosc);
        }
    }
}
?>
