<?php
// Wczytaj PEAR DB.
require 'DB.php';
// Wczytaj funkcje pomocnicze formularza.
require 'funkcje_pomocnicze.php';

// Nawizanie poczenia z baz danych.
$db = DB::connect('mysql://mysliwy:w)mp3s@db.przyklad.com/restauracja');
if (DB::isError($db)) { die ("Nie mog nawiza poczenia: " . $db->getMessage()); }
// Ustaw automatyczn obsug bdw.
$db->setErrorHandling(PEAR_ERROR_DIE);

// Warstwa logiczna strony gwnej:
// - Jeeli formularz zosta wysany, sprawd jego poprawno, a nastpnie przetwrz
// - lub wywietl ponownie.
// - Jeeli formularz nie zosta wysany, wywietl go.
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, a wic przetwrz je.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, a wic wywietl go.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    // Jeeli formularz zosta wysany,
    // pobierz wartoci domylne z wysanych parametrw.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym razie ustaw wasne wartoci domylne: cena wynosi 5 z.
        $domyslne = array('cena' => '5.00');
    }

    // Jeeli zostay przekazane bdy,
    // umie je w zmiennej $tekst_bledu (ze znacznikami HTML).
    if (is_array($bledy)) {
        $tekst_bledu = '<tr><td>Musisz poprawi nastpujce bdy:';
        $tekst_bledu .= '</td><td><ul><li>';
        $tekst_bledu .= implode('</li><li>',$bledy);
        $tekst_bledu .= '</li></ul></td></tr>';
    } else {
        // Nie wystpiy bdy? Wwczas zmienna $tekst_bledu jest pusta.
        $tekst_bledu = '';
    }

    // Wyskakujemy z trybu PHP, aby mc atwiej wywietli wszystkie znaczniki HTML.
?>
<form method="POST" action="<?php print $_SERVER['PHP_SELF']; ?>">
<table>
<?php print $tekst_bledu ?>

<tr><td>Nazwa potrawy:</td>
<td><?php input_text('nazwa_potrawy', $domyslne) ?></td></tr>

<tr><td>Cena:</td>
<td><?php input_text('cena', $domyslne) ?></td></tr>

<tr><td>Ostro potrawy:</td>
<td><?php input_radiocheck('checkbox','czy_ostra', $domyslne, 'tak'); ?>
 Tak</td></tr>

<tr><td colspan="2" align="center"><?php przycisk_wyslij('zapisz','Zamawiam'); ?>
</td></tr>

</table>
<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>
</form>
<?php
      } // Koniec funkcji pokaz_formularz().

function sprawdz_formularz() {
    $bledy = array();

    // nazwa_potrawy jest wymagana.
    if (! strlen(trim($_POST['nazwa_potrawy']))) {
        $bledy [] = 'Prosz poda nazw potrawy.';
    }

    // Cena musi by poprawn liczb zmiennoprzecinkow
    // wiksz od 0.
    if (floatval($_POST['cena'] <= 0) {
        $bledy [] = 'Prosz poda prawidow cen.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Dostp do zmiennej globalnej $db wewntrz tej funkcji.
    global $db;

    // Pobierz unikalny identyfikator dla tej potrawy.
    $id_potrawy = $db->nextID('potrawy');

    // Ustaw warto zmiennej $czy_ostra na podstawie p wyboru.
    if ($_POST['czy_ostra'] == 'tak') {
        $czy_ostra = 1;
    } else {
        $czy_ostra = 0;
    }

    // Umie now potraw w tabeli.
    $db->query('INSERT INTO potrawy (id_potrawy, nazwa_potrawy, cena, czy_ostra)
                VALUES (?,?,?,?)',
               array($id_potrawy, $_POST['nazwa_potrawy'], $_POST['cena'],
                     $czy_ostra));

    // Powiedz uytkownikowi, e potrawa zostaa dodana.
    print 'Potrawa ' . htmlentities($_POST['nazwa_potrawy']) .
          ' zostaa dodana do bazy danych.';
}

?>
