<?php
// Ustawia tablice wyborw w zaznaczonych menu,
// ktre s potrzebne w funkcjach: wyswietl_formularz(), sprawdz_formularz(),
// i przetworz_formularz(), dlatego te zostay zadeklarowane globalnie.
$slodycze = array('sezam' => 'Francuskie ciasto z sezamem',
                'kokos' => 'elatynowe mleczko kokosowe',
                'ciasto' => 'Ciasto z brzowym cukrem',
                'ryzmieso' => 'Sodki ry z misem');

$glowna_potrawa = array('ryba' => 'Duszona ryba',
                     'zoladek' => "Smaone odki",
                     'flaki' => 'Smaone flaki z sosem winnym',
                     'taro' => 'Duszona wieprzowina z taro',
                     'drob' => 'Pieczone podroby drobiowe z sol',
                     'uchowiec' => 'Ucho morskie z kabaczkiem oraz kacz nok');

// Logika strony gwnej:
// - Jeeli formularz zostanie wysany, sprawd poprawno, a nastpnie przetwrz
//  lub wywietl ponownie.
// - Jeeli formularz nie zosta wysany, wywietl go.
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeli funkcja sprawdz_formularz() zwraca bdy, przeka je do pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, a wic przetwrz je.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, a wic wywietlamy go.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    // Jeeli formularz zosta wysany, pobierz wartoci domylne z parametrw.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W innym przypadku ustaw wasne wartoci domylne: wielko redni
        // oraz dostaw.
        $domyslne = array('dostawa' => 'tak',
                          'wielkosc'     => 'redni');
    }

    // Jeeli zostay przekazane bdy, umie je w $tekst_bledu (ze skadni HTML).
    if ($bledy) {
        $tekst_bledu = '<tr><td>Musisz poprawi nastpujce bdy:';
        $tekst_bledu .= '</td><td><ul><li>';
        $tekst_bledu .= implode('</li><li>',$bledy);
        $tekst_bledu .= '</li></ul></td></tr>';
    } else {
        // Brak bdw? Wwczas $tekst_bledu jest pusty.
        $tekst_bledu = '';
    }

    // Wyskocz z trybu PHP, aby atwiej wywietli wszystkie znaczniki HTML.
?>
<form method="POST" action="<?php print $_SERVER['PHP_SELF']; ?>">
<table>
<?php print $tekst_bledu ?>

<tr><td>Podaj nazwisko:</td>
<td><?php wprowadz_tekst('nazwisko', $domyslne) ?></td></tr>

<tr><td>Wielko:</td>
<td><?php wprowadz_przycisk_opcji('radio','size', $domyslne, 'small');  ?> May <br/>
<?php wprowadz_przycisk_opcji('radio','size', $domyslne, 'medium'); ?> redni <br/>
<?php wprowadz_przycisk_opcji('radio','size', $domyslne, 'large');  ?> Duy
</td></tr>

<tr><td>Wybierz jeden sodki element:</td>
<td><?php wprowadz_menu('slodycze', $domyslne, $GLOBALS['slodycze']); ?>
</td></tr>

<tr><td>Wybierz dwa dania gwne:</td>
<td>
<?php wprowadz_menu('glowna_potrawa', $domyslne, $GLOBALS['glowna_potrawa'], true) ?>
</td></tr>

<tr><td>Czy mamy dostarczy Twoje zamwienie?</td>
<td><?php wprowadz_przycisk_opcji('checkbox','dostawa', $domyslne, 'yes'); ?> Tak
</td></tr>

<tr><td>Podaj informacje dodatkowe.<br/>
Jeeli chcesz, aby Twoje zamwienie zostao dostarczone, umie tutaj adres:</td>
<td><?php wprowadz_pole_tekstowe('komentarz', $domyslne); ?></td></tr>

<tr><td colspan="2" align="center"><?php przycisk_wyslij('save','Order'); ?>
</td></tr>

</table>
<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>
</form>
<?php
      } // Koniec funkcji pokaz_formularz().

function sprawdz_formularz() {
    $bledy = array();

    // Nazwisko jest wymagane.
    if (! strlen(trim($_POST['nazwisko']))) {
        $bledy[] = 'Prosz poda nazwisko.';
    }
    // Wielko jest wymagana.
    if (($_POST['wielkosc'] != 'small') && ($_POST['wielkosc'] != 'medium') &&
        ($_POST['wielkosc'] != 'large')) {
        $bledy[] = 'Prosz wybra wielko.';
    }
    // Element slodycze jest wymagany.
    if (! array_key_exists($_POST['slodycz'], $GLOBALS['slodycze'])) {
        $bledy[] = 'Prosz wybra poprawny element ze sodyczy.';
    }
    // Dokadnie dwie potrawy gwne s wymagane.
    if (count($_POST['glowna_potrawa']) != 2) {
        $bledy[] = 'Prosz wybra dokadnie dwie potrawy gwne.';
    } else {
        // Wiemy, e dwie potrawy gwne s zaznaczone, tak wic upewnijmy si,
        // i obydwie s prawidowe.
        if (! (array_key_exists($_POST['glowna_potrawa'][0], $GLOBALS['glowna_potrawa']) &&
               array_key_exists($_POST['glowna_potrawa'][1], $GLOBALS['glowna_potrawa']))) {
            $bledy[] = 'Prosz wybra dokadnie dwie potrawy gwne.';
        }
    }
    // Jeeli zostaa zaznaczona dostawa, wwczas komentarz musi zawiera cokolwiek.
    if (($_POST['dostawa'] == 'yes') && (! strlen(trim($_POST['komentarz'])))) {
        $bledy[] = 'Prosz poda adres dostawy zamwienia.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Odszukaj w tablicach $GLOBALS['slodycze'] i $GLOBALS['glowna_potrawa']
    // pene nazwy sodyczy i potraw gwnych.
    $slodycz = $GLOBALS['slodycze'][ $_POST['slodycz'] ];
    $glowna_potrawa_1 = $GLOBALS['glowna_potrawa '][ $_POST['glowna_potrawa '][0] ];
    $glowna_potrawa_2 = $GLOBALS['glowna_potrawa '][ $_POST['glowna_potrawa '][1] ];
    if ($_POST['dostawa'] == 'yes') {
        $dostawa = 'Tak';
    } else {
        $dostawa = 'Nie';
    }
    // Utwrz tekst komunikatu zamwienia.
    $wiadomosc=<<<_ORDER_
Dzikujemy za zoenie zamwienia, $_POST[name].
Zamwiee $_POST[wielkosc] kawaek $slodycz, $glowna_potrawa_1 i $glowna_potrawa_2.
Dostawa: $dostawa.
_ORDER_;
    if (strlen(trim($_POST['komentarz']))) {
        $wiadomosc .= 'Twj komentarz: '.$_POST['komentarz'];
    }

    // Wylij wiadomo do szefa.
    mail('szef@restauracja.przyklad.com', 'Nowe zamwienie', $wiadomosc);
    // Wywietl wiadomo, ale zakoduj encje HTML
    // i zamie znaki nowych wierszy na znaczniki <br/>.
    print nl2br(htmlentities($wiadomosc));
}
?>
