﻿// Wyświetl pole tekstowe.
function wprowadz_tekst($nazwa_elementu, $wartosci) {
    print '<input type="text" name="' . $nazwa_elementu .'" value="';
    print htmlentities($wartosci[$nazwa_elementu]) . '">';
}

// Wyświetl przycisk "Wyślij".
function przycisk_wyslij($nazwa_elementu, $etykieta) {
    print '<input type="submit" name="' . $nazwa_elementu .'" value="';
    print htmlentities($etykieta) .'"/>';
}

// Wyświetl pole tekstowe formularza.
function wprowadz_pole_tekstowe($nazwa_elementu, $wartosci) {
    print '<textarea name="' . $nazwa_elementu .'">';
    print htmlentities($wartosci[$nazwa_elementu]) . '</textarea>';
}

// Wyświetl przycisk opcji lub pole wyboru.
function wprowadz_przycisk_opcji($typ, $nazwa_elementu, $wartosci, $wartosc_elementu) {
    print '<input type="' . $typ . '" name="' . $nazwa_elementu .'" value="' . $wartosc_elementu . '" ';
    if ($wartosc_elementu == $wartosci[$wartosc_elementu]) {
        print ' checked="checked"';
    }
    print '/>';
}

// Wyświetl menu <select>.
function wprowadz_menu($nazwa_elementu, $zaznaczony, $opcje, $multiple = false) {
    // Wyświetl znacznik <select>.
    print '<select name="' . $nazwa_elementu;
    // Jeżeli są dozwolone wielokrotne wybory, dodaj atrybut multiple
    // oraz dołącz [] na końcu nazwy znacznika.
    if ($multiple) { print '[]" multiple="multiple'; }
    print '">';

    // Ustaw listę elementów do zaznaczenia.
    $zaznaczone_opcje = array();
    if ($multiple) {
        foreach ($zaznaczony[$nazwa_elementu] as $wart) {
            $zaznaczone_opcje[$wart] = true;
        }
    } else {
        $zaznaczone_opcje[ $zaznaczony[$nazwa_elementu] ] = true;
    }

    // Wyświetl znaczniki <option>.
    foreach ($opcje as $opcja => $etykieta) {
        print '<option value="' . htmlentities($opcja) . '"';
        if ($zaznaczone_opcje[$opcja]) {
            print ' selected="selected"';
        }
        print '>' . htmlentities($etykieta) . '</option>';
    }
    print '</select>';
}
