<?php
  // Wczytaj funkcje pomocnicze.
require 'funkcje_pomocnicze.php';

if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic przetwrz formularz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    if ($bledy)) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';

    // Tytu:
    print 'Tytu: ';
    wprowadz_tekst('tytul', $_POST);
    print '<br/>';

    // Odnonik.
    print 'Odnonik: ';
    wprowadz_tekst('odnosnik', $_POST);
    print '<br/>';

    // Opis.
    print 'Opis: ';
    wprowadz_tekst('opis', $_POST);
    print '<br/>';

    // Przycisk "Wylij".
    przycisk_wyslij('submit','Wygeneruj wiadomoci');

    // Ukryta zmienna _sprawdz_czy_wyslac oraz koniec formularza.
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Tytu jest wymagany.
    if (! strlen(trim($_POST['tytul']))) {
        $bledy[] = 'Prosz poda tytu elementu.';
    }

    // Odnonik jest wymagany.
    if (! strlen(trim($_POST['odnosnik']))) {
        $bledy[] = 'Prosz poda odnonik dla elementu.';
    // Trudno jest dokadnie sprawdzi adres URL, ale moemy
    // przynajmniej upewni si, e rozpoczyna si od
    // prawidowego acucha.
    } elseif (! (substr($_POST['odnosnik'], 0, 7) == 'http://') ||
              (substr($_POST['odnosnik'], 0, 8) == 'https://')) {
        $bledy[] = 'Prosz poda poprawny http lub https adres URL.';
    }

    // Opis jest wymagany.
    if (! strlen(trim($_POST['opis']))) {
        $bledy[] = 'Prosz poda opis elementu.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Wylij nagwek Content-Type.
    header('Content-Type: text/xml');
    // Wywietl pocztek dokumentu XML, wczajc w to informacje o kanale.
    print<<<_XML_
<rss version="0.91">
 <channel>
  <title>Co jest na obiad?</title>
  <link>http://menu.przyklad.com/</link>
  <description>Poniej znajduj si moliwe do wyboru posiki na wieczr.</description>
   <item>
_XML_;

    // Wywietl wysane dane formularza.
    print '  <title>' . htmlentities($_POST['tytul']) . "</title>\n";
    print '  <link>' . htmlentities($_POST['odnosnik']) . "</link>\n";
    print '  <description>' . htmlentities($_POST['opis']) . "</description>\n";

    // Wywietl koniec dokumentu XML.
    print<<<_XML_
  </item>
 </channel>
</rss>
_XML_;
}
?>
