<?php
  // Wczytaj funkcje pomocnicze dla elementw formularza.
require 'funkcje_pomocnicze.php';
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic przetwrz formularz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';

    // Nazwa pliku.
    print' Podaj nazw pliku: ';
    input_text('nazwa_pliku', $_POST);
    print '<br/>';

    // Przycisk "Wylij".
    przycisk_wyslij('submit','Poka plik');

    // Ukryta zmienna _sprawdz_czy_wyslac.
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';

    // Koniec formularza.
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Nazwa pliku jest wymagana.
    if (! strlen(trim($_POST['nazwa_pliku']))) {
        $bledy[] = 'Prosz poda nazw pliku.';
    } else {
        // Tworzymy pen nazw pliku z katalogu gwnego serwera sieciowego,
        // sieciowego ukonika i nazwy wysyanego pliku.
        $nazwa_pliku = $_SERVER['DOCUMENT_ROOT'] . '/' . $_POST['nazwa_pliku'];

        // Uywamy rzeczywistej cieki, aby rozwiza ... sekwencje.
        $nazwa_pliku = realpath($nazwa_pliku);

        // Upewniamy si, e $nazwa_pliku rozpoczyna si w katalogu gwnym.
        $docroot_len = strlen($_SERVER['DOCUMENT_ROOT']);
        if (substr($nazwa_pliku, 0, $docroot_len) != $_SERVER['DOCUMENT_ROOT']) {
            $bledy[] = 'Nazwa pliku musi odnosi si do katalogu gwnego.';
        }
    }

    return $bledy;
}

function przetworz_formularz() {
    // Przywracamy pen nazw pliku, jak w funkcji przetworz_formularz().
    $nazwa_pliku = $_SERVER['DOCUMENT_ROOT'] . '/' . $_POST['nazwa_pliku'];
    $nazwa_pliku = realpath($nazwa_pliku);

    // Wywietlamy zawarto pliku.
    print file_get_contents($nazwa_pliku);
}
?>
