<?php
require 'funkcje_pomocnicze.php';
// Ustaw tablic miesicy, dni, lat, godzin i minut.
$miesiace = array(1 => 'Stycze', 2 => 'Luty', 3 => 'Marzec', 4 => 'Kwiecie',
                5 => 'Maj', 6 => 'Czerwiec', 7 => 'Lipiec', 8 => 'Sierpie',
                9 => 'Wrzesie', 10 => 'Padziernik', 11 => 'Listopad',
                12 => 'Grudzie');
$dni = array();
for ($i = 1; $i <= 31; $i++) { $dni[$i] = $i; }
$lata = array();
for ($rok = date('Y') -1, $max_rok = date('Y') + 5; $rok < $max_rok; $rok++) {
    $lata[$rok] = $rok;
}
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic przetwrz formularz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $miesiace, $dnie, $lata;

    // Jeeli formularz zosta wysany,
    // pobierz wartoci domylne z wysanych zmiennych.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym przypadku ustaw wasne wartoci domylne:
        // jeden miesic od chwili obecnej.
        $domyslny_znacznik_czasu = strtotime('+1 month');
        $domyslne = array('miesiac' => date('n', $domyslny_znacznik_czasu),
                          'dzien'   => date('j', $domyslny_znacznik_czasu),
                          'rok'     => date('Y', $domyslny_znacznik_czasu));

    }

    // Jeeli zostay przekazane bdy, umie je w zmiennej
    // $tekst_bledu (razem ze znacznikami HTML).
    if ($bledy) {
        print 'Musisz poprawi nastpujce bedy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print 'Podaj dat i czas:';

    wprowadz_menu('dzien',$domyslne,$dni);
    print ' ';
    wprowadz_menu('miesiac',$domyslne,$miesiace);
    print ' ';
    wprowadz_menu('rok',$domyslne,$lata);
    print '<br/>';
    przycisk_wyslij('submit','Znajd wtorki');
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    global $miesiace, $dni, $lata;

    $bledy = array();

   if (! array_key_exists($_POST['dzien'], $dni)) {
        $bledy[] = 'Zaznacz poprawny dzie.';
    }

   if (! array_key_exists($_POST['miesiac'], $miesiace)) {
        $bledy[] = 'Zaznacz poprawny miesic.';
    }

    if (! array_key_exists($_POST['rok'], $lata)) {
        $bledy[] = 'Zaznacz poprawny rok.';
    }

    // Upewnij si, e wysana data jest w przyszoci.
    // Znajd czas od pocztku epoki dla dzisiejszej pnocy.
    // Opuszczonym argumentom: dzie, miesic i rok
    // przypisz wartoci domylne dla dnia dzisiejszego.
    $polnoc = mktime(0,0,0);
    // Znajd czas od pocztku epoki dla pnocy wysanej daty.
    $polnoc_wyslanej_daty = mktime(0,0,0,$_POST['miesiac'], $_POST['dzien'],
                                 $_POST['rok']);

    if ($polnoc_wyslanej_daty <= $polnoc) {
        $bledy[] = 'Podaj dat z przyszoci.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Utwrz czas od pocztku epoki dla daty podanej przez uytkownika.
    $polnoc_wyslanej_daty = mktime(0,0,0,$_POST['miesiac'], $_POST['dzien'],
                                 $_POST['rok']);
    // Pobierz czas od pocztku epoki dla nastpnego wtorku (wczajc dzie
    // dzisiejszy, jeli jest nim wtorek).
    $znacznik_czasu = strtotime('tuesday');

    if ($znacznik_czasu >= $polnoc_wyslanej_daty) {
        print 'Nie ma wtorku pomidzy ';
        print date('l, F j, Y');
        print ', a ';
        print date('l, F j, Y.', $polnoc_wyslanej_daty);
    } else {
        while ($znacznik_czasu < $polnoc_wyslanej_daty) {
            // Wywietl sformatowany acuch daty
            // dla $znacznik_czasu (ktrym jest wtorek).
            print date('l, F j, Y', $znacznik_czasu);
            print '<br/>';
            // Dodaj tydzie do zmiennej $znacznik_czasu.
            $znacznik_czasu = strtotime('+1 week', $znacznik_czasu);
        }
    }
}
?>
