// Strona zamwienia:
<?php
session_start();
require 'funkcje_pomocnicze.php';
$produkty = array('ryba'     => 'Duszona ryba',
                  'zoladek'  => "Smaone odki",
                  'flaki'    => 'Smaone flaki z sosem winnym',
                  'taro'     => 'Duszona wieprzowina z taro',
                  'drob'     => 'Pieczone podroby drobiowe z sol',
                  'uchowiec' => 'Ucho morskie z kabaczkiem oraz kacz nok');
if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        przetworz_formularz();
    }
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $produkty;

    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';

    if ($bledy) {
        print '<ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }
    // Utwrz tablic wartoci domylnych, jeeli w sesji jest zapisane
    // zamwienie.
    if ($_SESSION['zapisane_zamowienie']) {
        $domyslne = array();
        foreach ($produkty as $produkt => $opis) {
            $domyslne["potrawa_$produkt"] = $_SESSION["potrawa_$produkt"];
        }
    } else {
        $domyslne = $_POST;
    }
    foreach ($produkty as $produkt => $opis) {
        wprowadz_tekst("potrawa_$produkt", $domyslne);
        print " $opis<br/>";
    }

    przycisk_wyslij('submit','Zamawiam');

    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    global $produkty;
    $bledy = array();

    foreach ($produkty as $produkt => $opis) {
        // Jeeli w polu tekstowym zostao cokolwiek wpisane...
        if (strlen($_POST["potrawa_$produkt"]) &&
            // ...i nie jest poprawn liczb cakowit...
            (($_POST["potrawa_$produkt"] != strval(intval($_POST["potrawa_$produkt"]))) ||
             // ...lub jest mniejsze od zera...
             intval($_POST["potrawa_$produkt"]) < 0)) {
            // ... wwczas otrzymujemy bd.
            $bledy[] = "Prosz poda poprawn ilo dla $opis.";
        }
    }

    return $bledy;
}

function przetworz_formularz() {
    global $produkty;
    $_SESSION['zapisane_zamowienie'] = 1;

    foreach ($produkty as $produkt => $opis) {
        if (strlen($_POST["potrawa_$produkt "])) {
            $_SESSION["potrawa_$produkt"] = $_POST["potrawa_$produkt"];
        }
    }
    print 'Dzikujemy za zoenie zamwienia.';
}
?>

// Oto strona finalizacji zamwienia:
<?php
session_start();

require 'funkcje_pomocnicze.php';

$produkty = array('ryba'     => 'Duszona ryba',
                  'zoladek'  => "Smaone odki",
                  'flaki'    => 'Smaone flaki z sosem winnym',
                  'taro'     => 'Duszona wieprzowina z taro',
                  'drob'     => 'Pieczone podroby drobiowe z sol',
                  'uchowiec' => 'Ucho morskie z kabaczkiem oraz kacz nok');

// Poniewa formularz zawiera jedynie jeden przycisk,
// nie ma potrzeby sprawdzania wysanych danych formularza.
if ($_POST['_sprawdz_czy_wyslac']) {
    przetworz_formularz();
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $produkty;

    if ($_SESSION['zapisane_zamowienie']) {
        print 'Twoje zamwienie: <ul>';
        foreach ($produkty as $produkt => $opis) {
            if (array_key_exists("potrawa_$produkt", $_SESSION)) {
                print '<li> '.$_SESSION["potrawa_$produkt"]." $opis </li>";
            }
        }
        print '</ul>';
    } else {
        print 'Nie ma zapisanych zamwie.';
    }
    print '<br/>';
    // Zakadamy, e strona z zamwieniem
    // zostaa zapisana jako "formularz_zamowienia.php"
    print '<a href="formularz_zamowienia.php">Powrt do strony zamwienia</a>';
    print '<br/>';
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    input_submit('submit','Skadam zamwienie');
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function przetworz_formularz() {
    global $produkty;
    unset($_SESSION['zapisane_zamowienie']);

    foreach ($produkty as $produkt => $opis) {
        unset($_SESSION["potrawa_$produkt"]);
    }
    print 'Twoje zamwienie zostao przyjte.';
}

?>
