// Struktura tabeli klienci:
CREATE TABLE klienci (
id_klienta INT UNSIGNED NOT NULL,
nazwisko_klienta VARCHAR(255),
telefon VARCHAR(15),
id_ulubionej_potrawy INT UNSIGNED
)

// Formularz, ktry umieszcza nowego klienta:
<?php
require 'DB.php';
require 'funkcje_pomocnicze.php';

// Nawizanie poczenia z baz danych.
$db = DB::connect('mysql://mysliwy:w)mp3s@db.przyklad.com/restauracja');
if (DB::isError($db)) { die ("Nie mona nawiza poczenia: " . $db->getMessage()); }

// Ustaw automatyczn obsug bdw.
$db->setErrorHandling(PEAR_ERROR_DIE);

// Ustaw tryb pobierania: wiersze jako tablice asocjacyjne.
$db->setFetchMode(DB_FETCHMODE_ASSOC);

// Z bazy danych pobierz tablic nazw potraw.
$nazwy_potraw = array();
$res = $db->query('SELECT id_potrawy,nazwa_potrawy FROM potrawy');
while ($wiersz = $res->fetchRow()) {
    $nazwy_potraw[ $wiersz['id_potrawy'] ] = $wiersz['nazwa_potrawy'];
}

// Logika strony gwnej:
// - Jeeli formularz zosta wysany, sprawd poprawno, a nastpnie przetwrz
//   lub wywietl ponownie.
// - Jeeli formularz nie zosta wysany, wywietl go.
if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic przetwrz formularz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $nazwy_potraw;

    // Jeeli formularz zosta wysany, pobierz wartoci domylne dla wysanych zmiennych.
    if ($_POST['_sprawdz_czy_wyslac']) {
        $domyslne = $_POST;
    } else {
        // W przeciwnym przypadku, brak wartoci domylnych.
        $domyslne = array();
    }

    // Jeeli zostay przekazane bdy, umie je w zmiennej $tekst_bledu
    // (ze znacznikami HTML).
    if ($bledy) {
        $tekst_bledu = '<tr><td>Musisz poprawi nastpujce bdy:';
        $tekst_bledu .= '</td><td><ul><li>';
        $tekst_bledu .= implode('</li><li>',$bledy);
        $tekst_bledu .= '</li></ul></td></tr>';
    } else {
        // Brak bdw? Wwczas zmienna $tekst_bledu jest pusta.
        $tekst_bledu = '';
    }

    // Wyskakujemy z trybu PHP, aby atwiej wywietli wszystkie znaczniki HTML.
?>
<form method="POST" action="<?php print $_SERVER['PHP_SELF']; ?>">
<table>
<?php print $tekst_bledu ?>

<tr><td>Nazwisko klienta:</td>
<td><?php wprowadz_tekst('nazwisko_klienta', $domyslne) ?></td></tr>

<tr><td>Numer telefonu:</td>
<td><?php wprowadz_tekst('telefon', $domyslne) ?></td></tr>

<tr><td>Ulubiona potrawa:</td>
<td><?php wprowadz_menu('id_ulubionej_potrawy', $domyslne, $nazwy_potraw); ?></td></tr>

<tr><td colspan="2" align="center"><?php przycisk_wyslij('save','Dodaj klienta'); ?>
</td></tr>

</table>
<input type="hidden" name="_sprawdz_czy_wyslac " value="1"/>
</form>
<?php
      } // Koniec funkcji przetworz_formularz()

function sprawdz_formularz() {
    global $nazwy_potraw;

    $bledy = array();

    // Element nazwisko_klienta jest wymagany.
    if (! strlen(trim($_POST['nazwisko_klienta']))) {
        $bledy[] = 'Prosz wpisa nazwisko klienta.';
    }

    // Numer telefonu jest wymagany i musi mie prawidowy zapis.
    if (! strlen(trim($_POST['telefon']))) {
        $bledy[] = 'Prosz poda numer telefonu';
    } elseif (! preg_match('/^\(\d{3}\) ?\d{3}-\d{4}$/', $_POST['telefon'])) {
        $bledy[] = 'Prosz poda numer telefonu w formacie (XXX) XXX-XXXX.';
    }

    // Podanie ulubionej potrawy jest wymagane.
    if (! array_key_exists($_POST['id_ulubionej_potrawy'], $nazwy_potraw)) {
        $bledy[] = 'Prosz zaznaczy ulubion potraw.';
    }

    return $bledy;
}

function przetworz_formularz() {
    // Dostp do zmiennej globalnej $db wewntrz tej funkcji.
    global $db;

    // Pobierz unikalne ID dla tego klienta.
    $id_klienta = $db->nextID('klienci');

    // Umie nowego klienta w tabeli.
    $db->query('INSERT INTO klienci (id_klienta, nazwisko_klienta, telefon, id_ulubionej_potrawy) VALUES (?,?,?,?)',
               array($id_klienta, $_POST['nazwisko_klienta'], $_POST['telefon'], $_POST['id_ulubionej_potrawy']));

    // Poinformuj uytkownika, e doda nowego klienta.
    print 'Klient o nazwisku ' . htmlentities($_POST['nazwisko_klienta']) . ' zosta dodany do bazy danych.';
}
?>
